/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.cache.Cache;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ObjectUtils;

abstract class ContextCache<T> {
    private final Object[] _params;
    private final String _method;
    private final Cache<ContextCache<?>, Object> _cache;

    protected ContextCache(@Nonnull Cache<ContextCache<?>, Object> cache, @Nonnull String method, Object ... params) {
        this._cache = cache;
        this._method = method;
        this._params = params;
    }

    @Nonnull
    protected abstract T loadValue();

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj instanceof ContextCache && ObjectUtils.equals((Object)this._method, (Object)((ContextCache)obj)._method) && Arrays.equals(this._params, ((ContextCache)obj)._params);
    }

    public final int hashCode() {
        return this._method.hashCode() ^ Arrays.hashCode(this._params);
    }

    @Nonnull
    final T load() {
        Object cachedResult = this._cache.getIfPresent((Object)this);
        if (cachedResult != null) {
            Object castedResult = cachedResult;
            return (T)castedResult;
        }
        T newResult = this.loadValue();
        this._cache.put((Object)this, newResult);
        return newResult;
    }

    public String toString() {
        return "Cache " + this._method + "(" + Arrays.toString(this._params) + ")";
    }
}

