/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.impl.HasAuthorizationCache;
import de.justsoftware.onx.authorization.business.impl.LoadOperation;
import de.justsoftware.onx.common.business.configfile.boolexpr.AbstractUnresolvedBoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.BoolExpr;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalContext;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.boolexpr.VarExpr;
import de.justsoftware.onx.common.shared.model.Authority;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class CalculationContext {
    private final Map<Object, InterimResults<?, ?>> _interimResults = Maps.newHashMap();
    private final HasAuthorizationCache _cacheHolder;

    CalculationContext(HasAuthorizationCache cacheHolder) {
        this._cacheHolder = cacheHolder;
    }

    void loadMissingValues() {
        for (InterimResults<?, ?> interimResult : this._interimResults.values()) {
            interimResult.loadMissingValues();
        }
    }

    @Nonnull
    private <K, V> BoolExpr get(Authority authority, K key, LoadOperation<K, V> load, CalculationCallback<V> callback) {
        return this.getInterimResults(load).get(authority, null, key, callback);
    }

    @Nonnull
    <K, V> BoolExpr get(Authority authority, K key, Function<Set<K>, Map<K, V>> load, CalculationCallback<V> callback) {
        return this.get(authority, key, LoadOperation.optional(load), (V result) -> (BoolExpr)result.transform(callback::onFound).or((Object)BoolExpr.FALSE));
    }

    @Nonnull
    <K> BoolExpr filter(Authority authority, K key, final Function<Set<K>, Set<? extends K>> load, CalculationCallback<Boolean> calback) {
        return this.get(authority, key, new LoadOperation<K, Boolean>(){

            @Override
            public Map<K, Boolean> load(Set<K> keys) {
                Set filtered = (Set)load.apply(keys);
                return Maps.asMap(keys, input -> filtered.contains(input));
            }

            @Override
            public Object getCacheKey() {
                return ImmutableList.of((Object)"filter", load.getClass());
            }
        }, calback);
    }

    void addKeys() {
        for (InterimResults<?, ?> interimResults : this._interimResults.values()) {
            interimResults.addKeys();
        }
    }

    void forgetKeys() {
        for (InterimResults<?, ?> interimResults : this._interimResults.values()) {
            interimResults.forgetKeys();
        }
    }

    @Nonnull
    private <K, V> InterimResults<K, V> getInterimResults(LoadOperation<K, V> operation) {
        InterimResults<?, ?> interimResults = this._interimResults.get(operation.getCacheKey());
        if (interimResults != null) {
            return interimResults;
        }
        InterimResults<K, V> newInterimResults = new InterimResults<K, V>(this._cacheHolder.getCache(operation));
        this._interimResults.put(operation, newInterimResults);
        return newInterimResults;
    }

    @ParametersAreNonnullByDefault
    private static final class InterimResults<K, V> {
        private final Map<K, V> _results = Maps.newHashMap();
        private final Set<K> _missing = Sets.newHashSet();
        private final Set<K> _keysToAdd = Sets.newHashSet();
        private final HasAuthorizationCache.AuthorizationContextCache<K, V> _cache;

        private InterimResults(HasAuthorizationCache.AuthorizationContextCache<K, V> cache) {
            this._cache = cache;
        }

        private void loadMissingValues() {
            if (!this._missing.isEmpty()) {
                this._results.putAll(this._cache.load(this._missing));
            }
            this._missing.clear();
        }

        @Nonnull
        private BoolExpr get(UnresolvedBoolExpr<K, V> expr) {
            return this.get(null, expr, expr._key, expr._callback);
        }

        @Nonnull
        private BoolExpr get(@Nullable Authority authority, @Nullable UnresolvedBoolExpr<K, V> expr, K key, CalculationCallback<V> callback) {
            V result = this._results.get(key);
            if (result != null) {
                return callback.onFound(result);
            }
            V cacheResult = this._cache.peek(key);
            if (cacheResult != null) {
                this._results.put(key, cacheResult);
                return callback.onFound(cacheResult);
            }
            this._keysToAdd.add(key);
            if (authority != null) {
                return new UnresolvedBoolExpr<K, V>(authority, this, key, callback);
            }
            if (expr != null) {
                return expr;
            }
            throw new IllegalArgumentException("One of the two first parameters needs to be not null!");
        }

        private void addKeys() {
            this._missing.addAll(this._keysToAdd);
            this.forgetKeys();
        }

        private void forgetKeys() {
            this._keysToAdd.clear();
        }
    }

    private static final class UnresolvedBoolExpr<K, V>
    extends AbstractUnresolvedBoolExpr<VarExpr> {
        private final K _key;
        private final CalculationCallback<V> _callback;
        private final InterimResults<K, V> _interimResults;

        private UnresolvedBoolExpr(@Nonnull Authority authority, @Nonnull InterimResults<K, V> interimResults, @Nonnull K key, @Nonnull CalculationCallback<V> callback) {
            super(BoolExpr.var(authority), key, interimResults._cache._load.getCacheKey(), callback);
            this._interimResults = interimResults;
            this._key = key;
            this._callback = callback;
        }

        @Override
        public BoolExpr eval(EvalContext context) throws EvalException {
            return this._interimResults.get(this);
        }
    }

    @FunctionalInterface
    static interface CalculationCallback<V> {
        @Nonnull
        public BoolExpr onFound(@Nonnull V var1);
    }
}

