/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationKey;
import de.justsoftware.onx.authorization.business.NotAllowed;
import de.justsoftware.onx.authorization.business.NotFound;
import de.justsoftware.onx.authorization.business.PermissionRole;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.common.shared.model.Authority;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractAuthorizationCheckContext
implements AuthorizationCheckContext,
PersonIndependentAuthorizationContextProvider {
    protected final ImmutableSet<? extends Role> _rolesForNullUsers;
    protected final PermissionRequestConnector _permissionRequestConnector;

    protected AbstractAuthorizationCheckContext(@Nonnull PermissionRequestConnector permissionRequestConnector, @Nonnull ImmutableSet<? extends Role> rolesForNullUsers) {
        this._permissionRequestConnector = permissionRequestConnector;
        this._rolesForNullUsers = rolesForNullUsers;
    }

    @Override
    public final ImmutableSet<Action> may(Item<?> item, Action ... actions) {
        return this.may(item, (ImmutableSet<? extends Action>)ImmutableSet.copyOf((Object[])actions));
    }

    @Override
    public final boolean may(Action action) {
        return this.may((Item<?>)null, action);
    }

    @Override
    public final ImmutableSet<Action> may(ImmutableSet<? extends Action> actions) {
        return this.may((Item)null, actions);
    }

    @Override
    public final void check(Action action) {
        this.check((Item)null, action);
    }

    @Override
    public final <T extends Item<?>> Iterable<T> filterAllowedItems(Iterable<T> items, final Action action) {
        final ImmutableSetMultimap result = this.may((Iterable<? extends Item<? extends T>>)items, (Set)ImmutableSet.of((Object)action));
        return Iterables.filter(items, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return result.get(Identifiables.optionalIdOf(input)).contains((Object)action);
            }
        });
    }

    @Override
    public final <T extends ItemId> ImmutableSet<T> filterAllowedIds(Iterable<T> itemIds, final Action action) {
        final ImmutableSetMultimap result = this.may((Iterable<? extends Item<? extends T>>)this.getItems(itemIds), (Set)ImmutableSet.of((Object)action));
        return ImmutableSet.copyOf((Iterable)Iterables.filter(itemIds, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return result.get((Object)Optional.fromNullable(input)).contains((Object)action);
            }
        }));
    }

    @Nonnull
    private <T extends ItemId> LinkedList<Item<? extends T>> getItems(@Nonnull Iterable<T> itemIds) {
        LinkedList items = Lists.newLinkedList((Iterable)this.getPersonIndependentAuthorizationContext().getItemsByIds(itemIds).values());
        if (Iterables.contains(itemIds, null)) {
            items.add(null);
        }
        return items;
    }

    @CheckForNull
    protected final Item<?> getItemById(@Nullable ItemId itemId) {
        return itemId != null ? (Item)this.getPersonIndependentAuthorizationContext().getItemsByIds(ImmutableSet.of((Object)itemId)).get((Object)itemId) : null;
    }

    @Override
    public final boolean may(ItemId itemId, Action action) {
        return this.may(this.getItemById(itemId), action);
    }

    @Override
    public final void check(ItemId itemId, Action action) {
        this.check(this.getItemById(itemId), action);
    }

    @Override
    public void check(@Nullable ItemId itemId, ImmutableSet<? extends Action> actions) {
        this.check(this.getItemById(itemId), actions);
    }

    @Override
    public final void check(@Nullable Item<?> item, Action action) {
        this.check(item, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)action));
    }

    @Override
    public final void check(Item<?> item, ImmutableSet<? extends Action> actions) {
        this.checkItems((Iterable<? extends Item<?>>)Collections.singleton(item), (Set<? extends Action>)actions);
    }

    @Override
    public final void check(Iterable<? extends ItemId> itemIds, Set<? extends Action> actions) {
        this.checkItems(this.getItems(itemIds), actions);
    }

    @Override
    public final ImmutableSet<Action> may(ItemId itemId, ImmutableSet<? extends Action> actions) {
        return this.may(this.getItemById(itemId), actions);
    }

    @Override
    public final boolean may(Item<?> item, Action action) {
        return this.may(item, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)action)).contains((Object)action);
    }

    @Override
    public final ImmutableSet<Action> may(Item<?> item, ImmutableSet<? extends Action> actions) {
        return this.may((Iterable)Collections.singleton(item), (Set)actions).get(Identifiables.optionalIdOf(item));
    }

    @Override
    public final <T extends ItemId, A extends Action> ImmutableSetMultimap<Optional<T>, A> may(Iterable<? extends Item<? extends T>> items, Set<? extends A> actions) {
        if (Iterables.isEmpty(actions) || Iterables.isEmpty(items)) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSet<AuthorizationKey<? extends Item<? extends T>, ? extends A>> authorizationResult = this.getPersonIndependentAuthorizationContext().may(items, Collections.singleton(this.getCurrentPerson()), actions, this._rolesForNullUsers);
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (AuthorizationKey authorizationKey : authorizationResult) {
            result.put(Identifiables.optionalIdOf(authorizationKey.getItem()), (Object)((Action)authorizationKey.getAdditional()));
        }
        return result.build();
    }

    @Override
    public <T extends ItemId, A extends Action> ImmutableSetMultimap<T, A> may(SetMultimap<T, ? extends A> actionsPerItem) {
        ImmutableMap items = this.getPersonIndependentAuthorizationContext().getItemsByIds(actionsPerItem.keySet());
        ImmutableSet.Builder authorizationKeyBuilder = ImmutableSet.builder();
        DBPerson currentPerson = this.getCurrentPerson();
        for (Item item : items.values()) {
            for (Action action : actionsPerItem.get(item.getId())) {
                authorizationKeyBuilder.add(new AuthorizationKey<Item, Action>(item, currentPerson, action));
            }
        }
        ImmutableSet allowed = this.getPersonIndependentAuthorizationContext().may(authorizationKeyBuilder.build());
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (AuthorizationKey key : allowed) {
            Object item = key.getItem();
            if (item == null) continue;
            result.put(item.getId(), (Object)((Action)key.getAdditional()));
        }
        return result.build();
    }

    @CheckForNull
    protected abstract DBPerson getCurrentPerson();

    @Override
    public final <A extends Authority> ImmutableSet<A> hasAuthorities(Item<?> item, Set<A> authorities) {
        return this.getPersonIndependentAuthorizationContext().hasAuthorities(item, this.getCurrentPerson(), this._rolesForNullUsers, authorities);
    }

    @Override
    public final <T extends ItemId, A extends Action> ImmutableSetMultimap<Optional<T>, A> mayByIds(Iterable<? extends T> itemIds, Set<? extends A> actions) {
        return this.may((Iterable<? extends Item<? extends T>>)this.getPersonIndependentAuthorizationContext().getItemsByIds(itemIds).values(), actions);
    }

    @Override
    public final void invalidate() {
        this.getPersonIndependentAuthorizationContext().invalidate();
    }

    @Override
    public boolean may(ProfileReadRole toCheck) {
        return this.may(toCheck.asPermissionRole());
    }

    @Override
    public boolean may(de.justsoftware.permission.client.model.Role toCheck) {
        return this.has(toCheck) == AuthorizationResult.OK;
    }

    @Override
    public void check(ImmutableCollection<ProfileReadRole> toCheck) throws PermissionDeniedException {
        this.check((Set)toCheck.stream().map(PermissionRole::asPermissionRole).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public void check(ProfileReadRole toCheck) throws PermissionDeniedException {
        this.check(toCheck.asPermissionRole());
    }

    @Override
    public ImmutableSet<ProfileId> filterRoles(ImmutableCollection<ProfileReadRole> rolesToCheck) {
        Map permissionRolesToProfileMapping = (Map)ImmutableSet.copyOf(rolesToCheck).stream().collect(ImmutableMap.toImmutableMap(PermissionRole::asPermissionRole, ProfileReadRole::getProfileId));
        ImmutableSet allowed = this._permissionRequestConnector.filterRoles(permissionRolesToProfileMapping.keySet(), this.getUserRoles());
        return (ImmutableSet)allowed.stream().map(permissionRolesToProfileMapping::get).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    abstract ImmutableSet<de.justsoftware.permission.client.model.Role> getUserRoles();

    private ImmutableMap<de.justsoftware.permission.client.model.Role, AuthorizationResult> has(Set<de.justsoftware.permission.client.model.Role> toCheck) {
        return this._permissionRequestConnector.hasRoles(toCheck, this.getUserRoles());
    }

    private AuthorizationResult has(de.justsoftware.permission.client.model.Role toCheck) {
        return (AuthorizationResult)this.has((Set<de.justsoftware.permission.client.model.Role>)ImmutableSet.of((Object)toCheck)).get((Object)toCheck);
    }

    private void check(de.justsoftware.permission.client.model.Role toCheck) throws PermissionDeniedException {
        this.check((Set<de.justsoftware.permission.client.model.Role>)ImmutableSet.of((Object)toCheck));
    }

    private void check(Set<de.justsoftware.permission.client.model.Role> toCheck) throws PermissionDeniedException {
        ImmutableMap<de.justsoftware.permission.client.model.Role, AuthorizationResult> result = this.has(toCheck);
        ImmutableSet notFound = (ImmutableSet)toCheck.stream().filter(role -> AuthorizationResult.NOT_FOUND.equals(result.getOrDefault(role, (Object)AuthorizationResult.NOT_FOUND))).collect(ImmutableSet.toImmutableSet());
        if (!notFound.isEmpty()) {
            throw new NotFound((ImmutableSet<? extends de.justsoftware.permission.client.model.Role>)notFound);
        }
        ImmutableSet notAllowed = (ImmutableSet)toCheck.stream().filter(role -> AuthorizationResult.NOT_ALLOWED.equals(result.get(role))).collect(ImmutableSet.toImmutableSet());
        if (!notAllowed.isEmpty()) {
            throw new NotAllowed((ImmutableSet<? extends de.justsoftware.permission.client.model.Role>)notAllowed);
        }
    }
}

