/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class Roles {
    public static final ImmutableSetMultimap<StaticRole, EntityMemberRole> STATIC_ROLE_MAPPING = ImmutableSetMultimap.builder().putAll((Object)StaticPredefinedRole.ENTITY_CO_ADMIN, (Object[])new EntityMemberRole[]{EntityMemberRole.ADMIN, EntityMemberRole.CO_ADMIN}).putAll((Object)StaticPredefinedRole.ENTITY_ADMIN, (Object[])new EntityMemberRole[]{EntityMemberRole.ADMIN}).putAll((Object)StaticPredefinedRole.ENTITY_HAS_REJECTED, (Object[])new EntityMemberRole[]{EntityMemberRole.HAS_REJECTED, EntityMemberRole.EVENT_HAS_REJECTED_INVITATION}).putAll((Object)StaticPredefinedRole.ENTITY_MEMBER, EntityMemberRoles.HAS_MEMBER_RIGHTS).putAll((Object)StaticPredefinedRole.ENTITY_HAS_INVITATION, (Object[])new EntityMemberRole[]{EntityMemberRole.HAS_INVITATION, EntityMemberRole.EVENT_IS_INVITED}).putAll((Object)StaticPredefinedRole.ENTITY_UNDECIDED, (Object[])new EntityMemberRole[]{EntityMemberRole.IS_UNDECIDED, EntityMemberRole.EVENT_IS_MAYBE_ATTENDING}).putAll((Object)StaticPredefinedRole.ENTITY_HAS_SEND_JOINREQUEST, (Object[])new EntityMemberRole[]{EntityMemberRole.HAS_SENT_JOINREQUEST, EntityMemberRole.EVENT_IS_ON_WAITINGLIST}).put((Object)StaticPredefinedRole.EVENT_IS_ATTENDING, (Object)EntityMemberRole.EVENT_IS_ATTENDING).put((Object)StaticPredefinedRole.EVENT_IS_NOT_ATTENDING, (Object)EntityMemberRole.EVENT_IS_NOT_ATTENDING).put((Object)StaticPredefinedRole.EVENT_IS_MAYBE_ATTENDING, (Object)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING).put((Object)StaticPredefinedRole.EVENT_IS_ON_WAITINGLIST, (Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST).put((Object)StaticPredefinedRole.EVENT_IS_INVITED, (Object)EntityMemberRole.EVENT_IS_INVITED).put((Object)StaticPredefinedRole.EVENT_HAS_REJECTED_INVITATION, (Object)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION).build();

    private Roles() {
    }

    @Nonnull
    public static final ImmutableSet<String> intersectRoles(@Nonnull ImmutableSet<String> a, @Nonnull ImmutableSet<String> b) {
        boolean bLoggedIn;
        String all = StaticPredefinedRole.ALL.getName();
        String loggedIn = StaticPredefinedRole.LOGGED_IN.getName();
        boolean aAll = a.contains((Object)all);
        boolean bAll = b.contains((Object)all);
        if (aAll && bAll) {
            return ImmutableSet.of((Object)all);
        }
        boolean aLoggedIn = aAll || a.contains((Object)loggedIn);
        boolean bl = bLoggedIn = bAll || b.contains((Object)loggedIn);
        if (aLoggedIn && bLoggedIn) {
            return ImmutableSet.of((Object)loggedIn);
        }
        if (aLoggedIn) {
            return b;
        }
        if (bLoggedIn) {
            return a;
        }
        return ImmutableSet.copyOf((Collection)Sets.intersection(a, b));
    }
}

