/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.tasks.authorization.TaskAction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReadActions {
    public static final ImmutableMap<ComponentType, Action> READ_ACTIONS = ReadActions.createReadActionsMap();

    @CheckForNull
    public static Action readActionFor(@Nullable ComponentType componentType) {
        return (Action)READ_ACTIONS.get((Object)componentType);
    }

    @Nonnull
    private static ImmutableMap<ComponentType, Action> createReadActionsMap() {
        ImmutableSet as = ImmutableSet.builder().add((Object[])StaticAction.values()).add((Object[])StaticEntityAction.values()).add((Object[])StaticItemAction.values()).add((Object[])TaskAction.values()).build();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Action a : as) {
            ComponentType componentType = a.getComponentType();
            if (componentType == null || !a.isReadAction()) continue;
            result.put((Object)componentType, (Object)a);
        }
        return result.build();
    }
}

