/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business;

import com.google.common.base.Function;
import de.justsoftware.onx.common.shared.model.NameAndParam;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileRole
extends AbstractImmutableEqualsObject
implements Role {
    public static final Function<PersonId, ProfileRole> FROM_PERSON_ID = new NullPermeableFunction<PersonId, ProfileRole>(){

        @Override
        protected ProfileRole applySafe(PersonId input) {
            return new ProfileRole(input);
        }
    };
    private static final String PREFIX = "PROFILE,";
    private final PersonId _personId;

    public ProfileRole(PersonId personId) {
        super(personId);
        this._personId = personId;
    }

    public ProfileRole(ProfileId profileId) {
        this(profileId.asPersonId());
    }

    @Nonnull
    public static ProfileRole parse(String s) {
        if (s == null || !s.startsWith(PREFIX)) {
            throw new IllegalArgumentException(s + " is not a ProfileRole");
        }
        try {
            return new ProfileRole(new PersonId(Long.parseLong(s.substring(PREFIX.length()))));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public NameAndParam getNameAndParam() {
        return new NameAndParam(this, null);
    }

    @Override
    public String getName() {
        return PREFIX + this._personId.getId();
    }

    @Override
    public ProfileRole create(String param) {
        return this;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    @Nonnull
    public de.justsoftware.permission.client.model.Role asPermissionRole() {
        return de.justsoftware.permission.client.model.Role.profileRole((long)this._personId.getId());
    }
}

