/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.authorization.business;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.model.DBPerson;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseAuthorizationKey<I extends Item<?>, T>
extends AbstractImmutableEqualsObject {
    public static final Function<BaseAuthorizationKey<?, ?>, Item<?>> GET_ITEM = new Function<BaseAuthorizationKey<?, ?>, Item<?>>(){

        public Item<?> apply(BaseAuthorizationKey<?, ?> input) {
            return input != null ? (Item<?>)input.getItem() : null;
        }
    };
    public static final Function<BaseAuthorizationKey<?, ?>, ItemId> GET_ITEM_ID = Functions.compose(Identifiables.toId(), GET_ITEM);
    private final I _item;
    private final DBPerson _person;
    private final T _additional;
    private final ImmutableSet<? extends Role> _defaultRolesForNullUsers;

    public BaseAuthorizationKey(@Nullable I item, @Nullable DBPerson person, @Nonnull ImmutableSet<? extends Role> defaultRolesForNullUsers, @Nonnull T additional) {
        super(Identifiables.getIdFromNullable(item), Identifiables.getIdFromNullable(person), additional, defaultRolesForNullUsers);
        this._item = item;
        this._person = person;
        this._defaultRolesForNullUsers = defaultRolesForNullUsers;
        this._additional = additional;
    }

    @CheckForNull
    public final I getItem() {
        return this._item;
    }

    @CheckForNull
    public final DBPerson getPerson() {
        return this._person;
    }

    @CheckForNull
    public ComponentType getComponentType() {
        return null;
    }

    @Nonnull
    public final T getAdditional() {
        return this._additional;
    }

    @Nonnull
    public ImmutableSet<? extends Role> getDefaultRolesForNullUsers() {
        return this._defaultRolesForNullUsers;
    }
}

