/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.auditing.server.model.AuditingEntryId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditingEntry {
    private final AuditingEntryId _id;
    private final PersonId _userId;
    private final Date _timestamp;
    private final String _calledMethod;
    private final ImmutableMap<String, String> _parameterMap;
    private final String _result;

    public AuditingEntry(@Nonnull AuditingEntryId id, @Nullable PersonId userId, @Nonnull Date timestamp, @Nonnull String calledMethod, @Nonnull ImmutableMap<String, String> parameterMap, @Nonnull String result) {
        this._id = id;
        this._userId = userId;
        this._timestamp = Dates.clone(timestamp);
        this._calledMethod = calledMethod;
        this._parameterMap = parameterMap;
        this._result = result;
    }

    @Nonnull
    public AuditingEntryId getId() {
        return this._id;
    }

    @CheckForNull
    public PersonId getUserId() {
        return this._userId;
    }

    @Nonnull
    public Date getTimestamp() {
        return Dates.clone(this._timestamp);
    }

    @Nonnull
    public String getCalledMethod() {
        return this._calledMethod;
    }

    @Nonnull
    public ImmutableMap<String, String> getParameterMap() {
        return this._parameterMap;
    }

    @Nonnull
    public String getResult() {
        return this._result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("userId", (Object)this._userId).add("timestamp", (Object)this._timestamp).add("calledMethod", (Object)this._calledMethod).add("parameterMap", this._parameterMap).add("result", (Object)this._result).toString();
    }
}

