/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.auditing.server.AuditingToStringRegistry;
import de.justsoftware.onx.auditing.server.AuditingUtil;
import de.justsoftware.onx.auditing.shared.AuditIgnore;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditingToStringUtil {
    private static final AuditingToStringVisitor<Object> OBJECT_VISITOR = new AbstractAuditingToStringVisitor<Object>(){

        @Override
        public void visit(MoreObjects.ToStringHelper helper, Object object) {
            helper.addValue(object);
        }
    };
    private static final AuditingToStringVisitor<Map<?, ?>> MAP_VISITOR = new AbstractAuditingToStringVisitor<Map<?, ?>>(){

        @Override
        public void visit(MoreObjects.ToStringHelper helper, Map<?, ?> object) {
            helper.add("size", object.size());
        }
    };
    private static final AuditingToStringVisitor<Collection<?>> COLLECTION_VISITOR = new AbstractAuditingToStringVisitor<Collection<?>>(){

        @Override
        public void visit(MoreObjects.ToStringHelper helper, Collection<?> object) {
            helper.add("size", object.size());
        }
    };
    private static final AuditingToStringVisitor<Throwable> EXCEPTION_VISITOR = new AbstractAuditingToStringVisitor<Throwable>(){

        @Override
        public void visit(MoreObjects.ToStringHelper helper, Throwable object) {
            helper.add("message", (Object)object.getMessage());
        }
    };
    private static final AuditingToStringVisitor<ServletResponse> SERVLET_RESPONSE_VISITOR = new AbstractAuditingToStringVisitor<ServletResponse>(){

        @Override
        public void visit(MoreObjects.ToStringHelper helper, ServletResponse object) {
            helper.add("contentType", (Object)object.getContentType()).add("encoding", (Object)object.getCharacterEncoding()).add("locale", (Object)object.getLocale());
        }
    };
    private static final AuditingToStringVisitor<ServletRequest> SERVLET_REQUEST_VISITOR = new AbstractAuditingToStringVisitor<ServletRequest>(){

        @Override
        public void visit(MoreObjects.ToStringHelper helper, ServletRequest object) {
            helper.add("contentType", (Object)object.getContentType()).add("encoding", (Object)object.getCharacterEncoding()).add("locale", (Object)object.getLocale());
        }
    };
    private static final ImmutableMap<Class<?>, AuditingToStringVisitor<?>> CASTING_MAP = ImmutableMap.builder().put(ImmutableMap.class, OBJECT_VISITOR).put(ImmutableCollection.class, OBJECT_VISITOR).put(Collection.class, COLLECTION_VISITOR).put(Map.class, MAP_VISITOR).put(Throwable.class, EXCEPTION_VISITOR).put(ServletResponse.class, SERVLET_RESPONSE_VISITOR).put(ServletRequest.class, SERVLET_REQUEST_VISITOR).build();
    private static final Logger LOG = LoggerFactory.getLogger(AuditingToStringUtil.class);
    private static final ThreadLocal<AuditingToStringRegistry> THREAD_TO_STRING_REGISTRY = new ThreadLocal();

    @Nonnull
    public static String toAuditString(@Nullable Object object) {
        if (object == null) {
            return "null";
        }
        AuditingToStringRegistry registry = THREAD_TO_STRING_REGISTRY.get();
        if (registry == null) {
            registry = new AuditingToStringRegistry();
            THREAD_TO_STRING_REGISTRY.set(registry);
        }
        return AuditingToStringUtil.toAuditString(registry, object);
    }

    @Nonnull
    private static MoreObjects.ToStringHelper getAuditToStringHelper(@Nonnull Object object) {
        return MoreObjects.toStringHelper((String)AuditingUtil.getNameFor(object.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static String toAuditString(@Nonnull AuditingToStringRegistry registry, @Nullable Object object) {
        if (object == null) {
            return "null";
        }
        if (registry.isRegistered(object)) {
            return AuditingToStringUtil.getAuditToStringHelper(object).add("objectId", registry.getId(object).intValue()).toString();
        }
        try {
            registry.register(object);
            String string = AuditingToStringUtil.visitTraversing(object).toString();
            return string;
        }
        catch (RuntimeException e) {
            LOG.error("Error while inspecting object " + object.getClass(), (Throwable)e);
            String string = "parser error";
            return string;
        }
        finally {
            registry.unregister(object);
            if (registry.isClean()) {
                THREAD_TO_STRING_REGISTRY.remove();
            }
        }
    }

    private static boolean shouldVisitReflective(@Nonnull Class<?> clazz) {
        return clazz.getName().startsWith("de.justsoftware") || clazz.getName().startsWith("com.freiheit");
    }

    private static boolean shouldAppend(@Nonnull Class<?> clazz) {
        return !clazz.isAnnotationPresent(AuditIgnore.class) && !clazz.getName().startsWith("#");
    }

    @Nonnull
    private static final MoreObjects.ToStringHelper visitTraversing(@Nonnull Object object) {
        MoreObjects.ToStringHelper helper = AuditingToStringUtil.getAuditToStringHelper(object);
        Class<?> type = object.getClass();
        while (!Object.class.equals(type)) {
            if (!AuditingToStringUtil.shouldAppend(type)) {
                return helper;
            }
            if (!AuditingToStringUtil.shouldVisitReflective(type)) {
                for (Map.Entry entry : CASTING_MAP.entrySet()) {
                    if (!((Class)entry.getKey()).isAssignableFrom(type)) continue;
                    ((AuditingToStringVisitor)entry.getValue()).visitObject(helper, object);
                    return helper;
                }
                OBJECT_VISITOR.visit(helper, object);
                return helper;
            }
            AuditingToStringUtil.visitReflective(helper, type, object, new HashSet<String>());
            type = type.getSuperclass();
        }
        return helper;
    }

    private static final void visitReflective(@Nonnull MoreObjects.ToStringHelper helper, @Nonnull Class<?> type, @Nonnull Object object, @Nonnull Set<String> handledFields) {
        AccessibleObject[] declaredFields = type.getDeclaredFields();
        AccessibleObject.setAccessible(declaredFields, true);
        for (AccessibleObject f : declaredFields) {
            if (AuditingUtil.shouldAppend((Field)f) && !handledFields.contains(((Field)f).getName())) {
                String name = AuditingUtil.getNameFor(f, ((Field)f).getName());
                Object value = AuditingUtil.getValueFor((Field)f, object);
                helper.add(name, (Object)AuditingToStringUtil.toAuditString(THREAD_TO_STRING_REGISTRY.get(), value));
            }
            handledFields.add(((Field)f).getName());
        }
    }

    private static abstract class AbstractAuditingToStringVisitor<T>
    implements AuditingToStringVisitor<T> {
        private AbstractAuditingToStringVisitor() {
        }

        @Override
        public final T accept(Object object) {
            if (object == null) {
                return null;
            }
            try {
                Object value = object;
                return (T)value;
            }
            catch (ClassCastException cce) {
                return null;
            }
        }

        @Override
        public final void visitObject(MoreObjects.ToStringHelper helper, Object object) {
            T value = this.accept(object);
            if (value != null) {
                this.visit(helper, value);
            }
        }
    }

    private static interface AuditingToStringVisitor<T> {
        public void visitObject(@Nonnull MoreObjects.ToStringHelper var1, @Nonnull Object var2);

        public void visit(@Nonnull MoreObjects.ToStringHelper var1, @Nonnull T var2);

        @CheckForNull
        public T accept(@Nullable Object var1);
    }
}

