/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.reflect.MethodSignature;

public class AuditingAspectData {
    private Date _startTime;
    private boolean _ignoreExecution = false;
    private boolean _changeHappened = false;
    private Object _result;
    private Throwable _error;
    private PersonId _userId;
    private int _callDepth = 0;
    private MethodSignature _methodSignature;
    private List<?> _methodArgs;
    private Class<?> _methodClass;

    public boolean isIgnoreExecution() {
        return this._ignoreExecution;
    }

    @Nonnull
    public AuditingAspectData setIgnoreExecution(boolean ignoreExecution) {
        this._ignoreExecution = ignoreExecution;
        return this;
    }

    public boolean isChangeHappened() {
        return this._changeHappened;
    }

    @Nonnull
    public AuditingAspectData setChangeHappened(boolean changeHappened) {
        this._changeHappened = changeHappened;
        return this;
    }

    @CheckForNull
    public Object getResult() {
        return this._result;
    }

    @Nonnull
    public AuditingAspectData setResult(@Nullable Object result) {
        this._result = result;
        return this;
    }

    @CheckForNull
    public Throwable getError() {
        return this._error;
    }

    @Nonnull
    public AuditingAspectData setError(@Nullable Throwable error) {
        this._error = error;
        return this;
    }

    @Nonnull
    public AuditingAspectData setStartTime() {
        this._startTime = new Date();
        return this;
    }

    @Nonnull
    public Date getStartTime() {
        return Dates.clone(this._startTime);
    }

    @Nonnull
    public AuditingAspectData setUserId(@Nullable PersonId userId) {
        this._userId = userId;
        return this;
    }

    @CheckForNull
    public PersonId getUserId() {
        return this._userId;
    }

    @Nonnull
    public AuditingAspectData setMethodSignature(@Nonnull MethodSignature signature) {
        this._methodSignature = signature;
        return this;
    }

    @Nonnull
    public MethodSignature getMethodSignature() {
        return this._methodSignature;
    }

    @Nonnull
    public AuditingAspectData setMethodArgs(@Nonnull Object[] args) {
        this._methodArgs = Collections.unmodifiableList(Lists.newArrayList((Object[])args));
        return this;
    }

    @Nonnull
    public List<?> getMethodArgs() {
        return this._methodArgs;
    }

    @CheckForNull
    public Object getResultOrError() {
        return this._error != null ? this._error : this._result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("startTime", (Object)this._startTime).add("ignoreExecution", this._ignoreExecution).add("changeHappened", this._changeHappened).add("result", this._result).add("error", (Object)this._error).add("userId", (Object)this._userId).add("callDepth", this._callDepth).add("methodSignature", (Object)this._methodSignature).add("methodeArgs", this._methodArgs).toString();
    }

    public boolean isRootCall() {
        return this._callDepth == 0;
    }

    public void registerCall() {
        ++this._callDepth;
    }

    public void unregisterCall() {
        --this._callDepth;
    }

    public AuditingAspectData setMethodClass(Class<?> methodClass) {
        this._methodClass = methodClass;
        return this;
    }

    public Class<?> getMethodClass() {
        return this._methodClass;
    }
}

