/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.integration.persistence.ibatis.impl;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.auditing.integration.persistence.ibatis.IbatisAuditingLogger;
import de.justsoftware.onx.auditing.integration.persistence.model.DBAuditingEntry;
import de.justsoftware.onx.auditing.integration.persistence.model.DBAuditingParameterEntry;
import de.justsoftware.onx.auditing.server.model.AuditingEntry;
import de.justsoftware.onx.auditing.server.model.AuditingEntryId;
import de.justsoftware.onx.auditing.shared.AuditIgnore;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@AuditIgnore(comment="do not audit the auditing process")
@ParametersAreNonnullByDefault
public class IbatisAuditingLoggerImpl
implements IbatisAuditingLogger {
    private static final String NAMESPACE = "AUDITING";
    private final SqlMapClient _auditingSqlMapClient;
    private final TransactionHelper _txHelper;

    public IbatisAuditingLoggerImpl(SqlMapClient auditingSqlMapClient, TransactionHelper transactionHelper) {
        this._auditingSqlMapClient = auditingSqlMapClient;
        this._txHelper = transactionHelper;
    }

    @Override
    public void logExecution(final PersonId userId, final String calledMethod, final ImmutableMap<String, String> parameterMap, final String result, final Date timestamp) {
        this._txHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AuditingEntryId entryId = (AuditingEntryId)IbatisDAOUtil.wrappedQueryForObject(IbatisAuditingLoggerImpl.this._auditingSqlMapClient, Statements.NEXT_AUDITING_ENTRY_ID.getQueryId());
                Preconditions.checkNotNull((Object)entryId);
                IbatisDAOUtil.wrappedInsert(IbatisAuditingLoggerImpl.this._auditingSqlMapClient, Statements.CREATE_AUDITING_ENTRY.getQueryId(), new DBAuditingEntry(entryId, userId, timestamp, calledMethod, result));
                int pos = 0;
                for (Map.Entry parameter : parameterMap.entrySet()) {
                    IbatisDAOUtil.wrappedInsert(IbatisAuditingLoggerImpl.this._auditingSqlMapClient, Statements.CREATE_AUDITING_PARAMETER_ENTRY.getQueryId(), new DBAuditingParameterEntry(entryId, pos++, (String)parameter.getKey(), (String)parameter.getValue()));
                }
            }
        });
    }

    @Override
    public ImmutableList<AuditingEntry> fetchAllAuditingData() {
        List<DBAuditingEntry> entries = IbatisDAOUtil.wrappedQueryForList(this._auditingSqlMapClient, Statements.FETCH_ALL_AUDITING_ENTRIES.getQueryId());
        List<DBAuditingParameterEntry> parameters = IbatisDAOUtil.wrappedQueryForList(this._auditingSqlMapClient, Statements.FETCH_ALL_AUDITING_ENTRY_PARAMETERS.getQueryId());
        HashMap<AuditingEntryId, ImmutableMap.Builder> entryParameterBuilderMap = new HashMap<AuditingEntryId, ImmutableMap.Builder>();
        for (DBAuditingParameterEntry pe : parameters) {
            ImmutableMap.Builder mapParameterNameValueBuilder = (ImmutableMap.Builder)entryParameterBuilderMap.get(pe.getEntryId());
            if (mapParameterNameValueBuilder == null) {
                mapParameterNameValueBuilder = ImmutableMap.builder();
                entryParameterBuilderMap.put(pe.getEntryId(), mapParameterNameValueBuilder);
            }
            mapParameterNameValueBuilder.put((Object)pe.getName(), (Object)pe.getValue());
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (DBAuditingEntry entry : entries) {
            ImmutableMap.Builder mapParameterNameValueBuilder = (ImmutableMap.Builder)entryParameterBuilderMap.get(entry.getId());
            ImmutableMap parameterNameValueMap = mapParameterNameValueBuilder == null ? ImmutableMap.of() : mapParameterNameValueBuilder.build();
            resultBuilder.add((Object)new AuditingEntry(entry.getId(), entry.getUserId(), entry.getTimestamp(), entry.getCalledMethod(), (ImmutableMap<String, String>)parameterNameValueMap, entry.getResult()));
        }
        return resultBuilder.build();
    }

    private static enum Statements {
        CREATE_AUDITING_ENTRY("AUDITING.createAuditingEntry"),
        NEXT_AUDITING_ENTRY_ID("AUDITING.nextAuditingEntryId"),
        CREATE_AUDITING_PARAMETER_ENTRY("AUDITING.createAuditingParameterEntry"),
        FETCH_ALL_AUDITING_ENTRIES("AUDITING.fetchAllAuditingEntries"),
        FETCH_ALL_AUDITING_ENTRY_PARAMETERS("AUDITING.fetchAllAuditingEntryParameters");

        private final String _queryId;

        private Statements(String queryId) {
            this._queryId = queryId;
        }

        @Nonnull
        public String getQueryId() {
            return this._queryId;
        }
    }
}

