/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.auditing.business.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.auditing.business.AuditingLogger;
import de.justsoftware.onx.auditing.server.AuditingAspectData;
import de.justsoftware.onx.auditing.server.AuditingUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.reflect.MethodSignature;

public class AsyncAuditingTask
implements Runnable {
    private final AuditingAspectData _auditingData;
    private final AuditingLogger _auditingLogger;

    public AsyncAuditingTask(@Nonnull AuditingAspectData auditingData, @Nonnull AuditingLogger auditingLogger) {
        this._auditingData = auditingData;
        this._auditingLogger = auditingLogger;
    }

    @Override
    public void run() {
        MethodSignature signature = this._auditingData.getMethodSignature();
        Method method = signature.getMethod();
        String calledMethod = this.resolveMethodName(this._auditingData.getMethodClass(), method);
        ImmutableMap<String, String> parameterMap = this.resolveParameterMap(signature, method, this._auditingData.getMethodArgs());
        String logResult = this.resolveResult(method, this._auditingData.getResultOrError());
        this._auditingLogger.logExecution(this._auditingData.getUserId(), calledMethod, parameterMap, logResult, this._auditingData.getStartTime());
    }

    @Nonnull
    private String resolveMethodName(@Nonnull Class<?> type, @Nonnull Method method) {
        return AuditingUtil.getNameFor(type) + "." + AuditingUtil.getNameFor(method, method.getName());
    }

    @Nonnull
    private String resolveResult(@Nonnull Method method, @Nullable Object result) {
        return AuditingUtil.toAuditString(method, result);
    }

    @Nonnull
    private ImmutableMap<String, String> resolveParameterMap(@Nonnull MethodSignature signature, @Nonnull Method method, @Nonnull List<?> args) {
        if (args.isEmpty()) {
            return ImmutableMap.of();
        }
        String[] parameterNames = signature.getParameterNames();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ImmutableMap.Builder parameterMapBuilder = ImmutableMap.builder();
        int i = 0;
        for (Object arg : args) {
            this.resolveParameterMap(arg, (String)(parameterNames != null ? parameterNames[i] : "" + i), parameterAnnotations[i], (ImmutableMap.Builder<String, String>)parameterMapBuilder);
            ++i;
        }
        return parameterMapBuilder.build();
    }

    private void resolveParameterMap(@Nullable Object value, @Nonnull String name, @Nonnull Annotation[] annotations, @Nonnull ImmutableMap.Builder<String, String> builder) {
        if (AuditingUtil.shouldAppend(annotations)) {
            builder.put((Object)AuditingUtil.getNameFor(annotations, name), (Object)AuditingUtil.toAuditString(AuditingUtil.getValueFor(annotations, value)));
        }
    }
}

