/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.shared.model;

import com.google.common.base.Function;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum CoreApp {
    CONVERSATIONS("CONVERSATIONS", "chat", ThemeAttributeType.APP_CHAT_BACKGROUND_COLOR),
    SOCIAL("SOCIAL", "connect", ThemeAttributeType.APP_CONNECT_BACKGROUND_COLOR),
    DRIVE("DRIVE", "drive", ThemeAttributeType.APP_DRIVE_BACKGROUND_COLOR),
    TASKS("TASKS", "tasks", ThemeAttributeType.APP_TASKS_BACKGROUND_COLOR),
    PEOPLE("PEOPLE", "people", ThemeAttributeType.APP_PEOPLE_BACKGROUND_COLOR),
    NEWS("NEWS", "news", ThemeAttributeType.APP_NEWS_BACKGROUND_COLOR),
    WIKI("WIKI", "wiki", ThemeAttributeType.APP_WIKI_BACKGROUND_COLOR),
    ADMIN("ADMIN", "admin", ThemeAttributeType.APP_ADMIN_BACKGROUND_COLOR),
    ARCHIVED_NEWS("ARCHIVED_NEWS", "archivednews", ThemeAttributeType.APP_NEWS_BACKGROUND_COLOR);

    public static final CoreApp ENTITY_DEFAULT;
    public static final Function<CoreApp, String> TO_NAME;
    private final AppId _appId;
    private final String _name;
    private final String _simpleName;
    private final ThemeAttributeType _themeAttributeType;

    private CoreApp(String name, String simpleName, ThemeAttributeType themeAttributeType) {
        this._name = name;
        this._simpleName = simpleName;
        this._themeAttributeType = themeAttributeType;
        this._appId = new AppId(simpleName);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public String getSimpleName() {
        return this._simpleName;
    }

    @Nonnull
    public ThemeAttributeType getThemeAttributeType() {
        return this._themeAttributeType;
    }

    @CheckForNull
    public static CoreApp valueOfOrNull(String name) {
        try {
            return CoreApp.valueOf(name);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    @CheckForNull
    public static CoreApp byAppId(AppId appId) {
        for (CoreApp app : CoreApp.values()) {
            if (!app.getAppId().equals(appId)) continue;
            return app;
        }
        return null;
    }

    @Nonnull
    public AppId getAppId() {
        return this._appId;
    }

    static {
        ENTITY_DEFAULT = SOCIAL;
        TO_NAME = new NullPermeableFunction<CoreApp, String>(){

            @Override
            protected String applySafe(CoreApp input) {
                return input.getName();
            }
        };
    }
}

