/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DBAdditionalAppInfo {
    private AppId _appId;
    private String _url;
    private String _icon;
    private String _color;
    private boolean _iframeApp;
    private boolean _openInSameTab;

    @Deprecated
    public DBAdditionalAppInfo() {
    }

    public DBAdditionalAppInfo(AppId appId, String url, @Nullable String icon, String color, boolean iframeApp, boolean openInSameTab) {
        this._appId = appId;
        this._url = url;
        this._icon = icon;
        this._color = color;
        this._iframeApp = iframeApp;
        this._openInSameTab = openInSameTab;
    }

    @Nonnull
    public AppId getAppId() {
        return this._appId;
    }

    public void setAppId(AppId appId) {
        this._appId = appId;
    }

    @Nonnull
    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @CheckForNull
    public String getIcon() {
        return this._icon;
    }

    public void setIcon(@Nullable String icon) {
        this._icon = icon;
    }

    @Nonnull
    public String getColor() {
        return this._color;
    }

    public void setColor(String color) {
        this._color = color;
    }

    public boolean isIframeApp() {
        return this._iframeApp;
    }

    public void setIframeApp(boolean iframeApp) {
        this._iframeApp = iframeApp;
    }

    public boolean isOpenInSameTab() {
        return this._openInSameTab;
    }

    public void setOpenInSameTab(boolean openInSameTab) {
        this._openInSameTab = openInSameTab;
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._appId, this._url, this._icon, this._color, this._iframeApp, this._openInSameTab};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DBAdditionalAppInfo && Arrays.equals(this.hashObjects(), ((DBAdditionalAppInfo)obj).hashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this._appId).add("url", (Object)this._url).add("icon", (Object)this._icon).add("color", (Object)this._color).add("iframeApp", this._iframeApp).add("openInSameTab", this._openInSameTab).toString();
    }

    @Nullable
    public static DBAdditionalAppInfo fromAppConfig(AppConfig appConfig) {
        boolean openInSameTab;
        String appColor = appConfig.getAppColor();
        String icon = appConfig.getIcon();
        Boolean iframeApp = appConfig.getIframeApp();
        String url = appConfig.getUrl();
        boolean bl = openInSameTab = appConfig.isOpenInSameTab() != null && appConfig.isOpenInSameTab() != false;
        if (url == null || appColor == null || iframeApp == null) {
            return null;
        }
        return new DBAdditionalAppInfo(appConfig.getAppId(), url, icon, appColor, iframeApp, openInSameTab);
    }
}

