/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.appswitcher.integration.persistence.AppConfigDAO;
import de.justsoftware.onx.appswitcher.model.DBAdditionalAppInfo;
import de.justsoftware.onx.appswitcher.model.DBApp;
import de.justsoftware.onx.appswitcher.model.DBAppVisibility;
import de.justsoftware.onx.appswitcher.model.DBTenantAppVisibility;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class IbatisAppConfigDAO
implements AppConfigDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisAppConfigDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("AppConfig");
    }

    @Override
    public void insertApp(DBApp app) {
        this._statementBuilder.insert("insertApp").param(app);
    }

    @Override
    public int deleteAppsByIds(Set<AppId> appIds) {
        if (appIds.isEmpty()) {
            return 0;
        }
        return this._statementBuilder.delete("deleteAppsByIds").param(IbatisDAOUtil.toIbatisList(appIds));
    }

    @Override
    public ImmutableList<DBApp> getAllApps() {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getAllApps").noParam()).asList();
    }

    @Override
    public void updateApp(DBApp app) {
        this._statementBuilder.update("updateApp").param(app);
    }

    @Override
    public void insertAdditionalAppInfo(DBAdditionalAppInfo additionalAppInfo) {
        this._statementBuilder.insert("insertAdditionalAppInfo").param(additionalAppInfo);
    }

    @Override
    public int deleteAdditionalAppInfoByAppIds(Set<AppId> appIds) {
        if (appIds.isEmpty()) {
            return 0;
        }
        return this._statementBuilder.delete("deleteAdditionalAppInfoByAppIds").param(IbatisDAOUtil.toIbatisList(appIds));
    }

    @Override
    public ImmutableList<DBAdditionalAppInfo> getAllAdditionalAppInfo() {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getAllAdditionalAppInfo").noParam()).asList();
    }

    @Override
    public void updateAdditionalAppInfo(DBAdditionalAppInfo additionalAppInfo) {
        this._statementBuilder.update("updateAdditionalAppInfo").param(additionalAppInfo);
    }

    @Override
    public void insertDefaultAppVisibility(DBAppVisibility appVisibility) {
        this._statementBuilder.insert("insertDefaultAppVisibility").param(appVisibility);
    }

    @Override
    public int deleteDefaultAppVisibilitiesByAppIds(Set<AppId> appIds) {
        if (appIds.isEmpty()) {
            return 0;
        }
        return this._statementBuilder.delete("deleteDefaultAppVisibilitiesByAppIds").param(IbatisDAOUtil.toIbatisList(appIds));
    }

    @Override
    public ImmutableList<DBAppVisibility> getAllDefaultAppVisibilities() {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getAllDefaultAppVisibilities").noParam()).asList();
    }

    @Override
    public void updateDefaultAppVisibility(DBAppVisibility appVisibility) {
        this._statementBuilder.update("updateDefaultAppVisibility").param(appVisibility);
    }

    @Override
    public void insertTenantAppVisibility(DBTenantAppVisibility appVisibility) {
        this._statementBuilder.insert("insertTenantAppVisibility").param(appVisibility);
    }

    @Override
    public int deleteTenantAppVisibilities(Set<DBTenantAppVisibility> appVisibilities) {
        if (appVisibilities.isEmpty()) {
            return 0;
        }
        return (Integer)this._statementBuilder.delete("deleteTenantAppVisibilities").partition(appVisibilities);
    }

    @Override
    public ImmutableList<DBTenantAppVisibility> getTenantAppVisibilitiesByTenantIds(Set<? extends TenantId> tenantIds) {
        if (tenantIds.isEmpty()) {
            return ImmutableList.of();
        }
        return this._statementBuilder.select("getTenantAppVisibilitiesByTenantIds").param(IbatisDAOUtil.toIbatisList(tenantIds)).asList();
    }

    @Override
    public void updateTenantAppVisibility(DBTenantAppVisibility appVisibility) {
        this._statementBuilder.update("updateTenantAppVisibility").param(appVisibility);
    }
}

