/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.business;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.permission.client.model.Role;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SetupNewCustomerAppConfigsVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SetupNewCustomerAppConfigsVersionUpdateProcessor.class);
    private static final Role ALL = Role.staticRole((String)"ALL");
    private static final Role TENANT_MANAGER = Role.staticRole((String)"TENANT_MANAGER");
    private static final AppConfig NEWS = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.NEWS, "News");
    private static final AppConfig CONNECT = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.CONVERSATIONS, "Connect");
    private static final AppConfig WIKI = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.WIKI, "Wiki");
    private static final AppConfig DRIVE = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.DRIVE, "Drive");
    private static final AppConfig TORO = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.SOCIAL, "Profile");
    private static final AppConfig PEOPLE = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.PEOPLE, "People");
    private static final AppConfig ADMIN = SetupNewCustomerAppConfigsVersionUpdateProcessor.coreApp(CoreApp.ADMIN, "Admin");
    private static final AppConfig SURVEY = new AppConfig(new AppId("survey"), "Survey", "https://survey.lamapoll.de/Umfrage-Beispiel/?ref=iframe&mode=fixed", "#8DC75B", "survey.svg", true, false);
    private static final AppConfig FORMS = new AppConfig(new AppId("forms"), "Forms", "https://pro.form.cloud/formcycle/form/provide/15205/", "#7197EB", "forms.svg", true, false);
    private static final AppConfig INSTAGRAM = new AppConfig(new AppId("instagram"), "Instagram", "https://www.instagram.com/just.social/", "#F2DA27", "instagram.svg", false, false);
    private static final AppConfig TOUR = new AppConfig(new AppId("tour"), "Tour", "https://www.just.social/Tour/", "#9675B5", "tour.svg", false, false);
    private static final AppConfig ANALYTICS = new AppConfig(new AppId("analytics"), "Analytics", "https://support.just.social/hc/de/articles/360020056180", "#EB6790", "analytics.svg", false, false);
    private static final AppConfig SUPPORT = new AppConfig(new AppId("support"), "Support", "https://support.just.social/", "#EB6790", "support.svg", false, false);
    private static final AppConfig WEBSITE = new AppConfig(new AppId("website"), "Website", "https://www.just.social/", "#016567", "homepage.svg", false, false);
    private static final AppId MEET_ID = new AppId("meet");
    private final String _currentVersion;
    private final AppConfigService _appConfigService;
    private final JucoServerVersionService _jucoServerVersionService;
    private final EntityConfigService _entityConfigService;
    private final EntityTypeAppMappingService _entityTypeAppMappingService;
    private final String _domain;

    @Autowired
    public SetupNewCustomerAppConfigsVersionUpdateProcessor(AppConfigService appConfigService, JucoServerVersionService jucoServerVersionService, EntityConfigService entityConfigService, EntityTypeAppMappingService entityTypeAppMappingService, @Value(value="${justconnect.version}") String currentVersion, @Value(value="${domain}") String domain) {
        this._appConfigService = appConfigService;
        this._jucoServerVersionService = jucoServerVersionService;
        this._entityConfigService = entityConfigService;
        this._entityTypeAppMappingService = entityTypeAppMappingService;
        this._domain = domain;
        this._currentVersion = currentVersion;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.3.0");
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.SETUP_NEW_CUSTOMER_APP_CONFIGS;
    }

    @Override
    public void process() {
        boolean isNewCustomer;
        boolean bl = isNewCustomer = !this._jucoServerVersionService.hasPreviousVersionBelow(this._currentVersion);
        if (!isNewCustomer) {
            return;
        }
        LOG.info("Setup app configurations for new customer!");
        this._appConfigService.setAllAppConfigs(this.newCustomerAppConfigs());
        this._appConfigService.setInitialAppVisibilityConfigsByTenant(null, this.newCustomerInitialAppVisibilityConfigs());
        this.setNewsEntityTypeMappings();
    }

    @Nonnull
    private ImmutableList<AppConfig> newCustomerAppConfigs() throws ServiceException {
        return ImmutableList.of((Object)NEWS, (Object)CONNECT, (Object)WIKI, (Object)DRIVE, (Object)TORO, (Object)PEOPLE, (Object)SetupNewCustomerAppConfigsVersionUpdateProcessor.createMeetApp(this._domain), (Object)SURVEY, (Object)FORMS, (Object)INSTAGRAM, (Object)TOUR, (Object)ANALYTICS, (Object[])new AppConfig[]{ADMIN, SUPPORT, WEBSITE});
    }

    @Nonnull
    private ImmutableTable<Role, AppId, InitialVisibility> newCustomerInitialAppVisibilityConfigs() {
        return ImmutableTable.builder().put((Object)ALL, (Object)TORO.getAppId(), (Object)InitialVisibility.INVISIBLE).put((Object)ALL, (Object)MEET_ID, (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)SURVEY.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)FORMS.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)SUPPORT.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)INSTAGRAM.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)TOUR.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)NEWS.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)PEOPLE.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)DRIVE.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)WIKI.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)CONNECT.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)ALL, (Object)WEBSITE.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)TENANT_MANAGER, (Object)ANALYTICS.getAppId(), (Object)InitialVisibility.VISIBLE).put((Object)TENANT_MANAGER, (Object)ADMIN.getAppId(), (Object)InitialVisibility.VISIBLE).build();
    }

    private static AppConfig createMeetApp(String domain) {
        return new AppConfig(MEET_ID, "Meet", "https://meet.just.social/just-" + domain + "CreateRoom?jwt=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJqdXN0Iiwicm9vbSI6IioiLCJpc3MiOiJqdXN0LW1lZXQiLCJtb2RlcmF0b3IiOiJ0cnVlIiwiZXhwIjoxODk2OTcxODM1LCJpYXQiOjE2MTMwMjY1ODksInN1YiI6Im1lZXQuanVzdC5zb2NpYWwifQ.U3eLc5LtFyVBCqeExuGy22kA4IyeL0UEUK3FqfhA1go", "#EF5350", "meet.svg", false, false);
    }

    @Nonnull
    private static AppConfig coreApp(CoreApp coreApp, String name) {
        return new AppConfig(coreApp.getAppId(), name, null, null, null, null, null);
    }

    private void setNewsEntityTypeMappings() {
        ImmutableList.of((Object)EntityType.NETWORK, (Object)EntityType.GROUP).forEach(entityType -> {
            if (this._entityConfigService.entityTypeActivated((EntityType)entityType)) {
                this._entityTypeAppMappingService.setAppForEntityType((EntityType)entityType, CoreApp.ARCHIVED_NEWS.getAppId());
                LOG.info("Entity type " + entityType + " assigned to news app.");
            } else {
                LOG.info("Entity type " + entityType + " not activated, will not be assigned to news app.");
            }
        });
    }
}

