/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.analytics.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import de.justsoftware.onx.analytics.integration.persistence.AnalyticsDAO;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisAnalyticsDAO
implements AnalyticsDAO {
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisAnalyticsDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._transactionHelper = transactionHelper;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("Analytics");
    }

    @Nonnull
    private ImmutableMap<ItemId, Integer> getCounts(Set<? extends ItemId> item) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getItemViews").partition(item)).asMap("itemId", "count");
    }

    @Override
    public int getItemViews(ItemId itemId) {
        Integer viewCount = (Integer)this.getCounts((Set<? extends ItemId>)ImmutableSet.of((Object)itemId)).get((Object)itemId);
        if (viewCount == null) {
            return 0;
        }
        return viewCount;
    }

    @Override
    public void increaseViewCounters(Multiset<? extends ItemId> items) {
        this._transactionHelper.doInTransactionWithoutResult(transactionStatus -> this._statementBuilder.batch(sqlmapClient -> {
            ImmutableMap<ItemId, Integer> counts = this.getCounts(items.elementSet());
            items.entrySet().forEach(entry -> {
                int count = entry.getCount();
                if (count > 0) {
                    ItemId element = (ItemId)entry.getElement();
                    ImmutableMap m = ImmutableMap.of((Object)"itemId", (Object)element, (Object)"count", (Object)count);
                    if (!counts.containsKey((Object)element)) {
                        this._statementBuilder.insert("insertViewCounter").param(m);
                    } else {
                        this._statementBuilder.update("increaseViewCounter").param(m);
                    }
                }
            });
        }));
    }
}

