/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlbumImageItem
implements Item<AlbumImageId> {
    public static final Function<DBAlbumImage, AlbumImageItem> FROM_DBIMAGE = new Function<DBAlbumImage, AlbumImageItem>(){

        public AlbumImageItem apply(DBAlbumImage input) {
            return AlbumImageItem.of(input);
        }
    };
    private final DBAlbumImage _albumImage;

    public AlbumImageItem(@Nonnull DBAlbumImage albumImage) {
        this._albumImage = albumImage;
    }

    @Override
    public AlbumImageId getId() {
        return this._albumImage.getId();
    }

    @Override
    public AlbumId getParentId() {
        return this._albumImage.getAlbumId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.ALBUMS;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    @Nonnull
    public DBAlbumImage getAlbumImage() {
        return this._albumImage;
    }

    @CheckForNull
    public static AlbumImageItem of(@Nullable DBAlbumImage image) {
        return image != null ? new AlbumImageItem(image) : null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("albumImage", (Object)this._albumImage).toString();
    }
}

