/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.album.integration.persistence.AlbumDAO;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.GlobalId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(value="mdlAlbumDAO")
public class IbatisAlbumDAO
implements AlbumDAO {
    private static final String NAMESPACE = "MdlAlbum.";
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapper;
    @Autowired
    private TransactionHelper _txh;

    @Override
    public Map<AlbumId, DBAlbum> getAlbumsByIds(Set<? extends AlbumId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MdlAlbum.getAlbumsByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableList<DBAlbumImage> getImagesByAlbumIds(Set<? extends AlbumId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "MdlAlbum.getImagesByAlbumIds", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableMap<AlbumImageId, DBAlbumImage> getImagesByIds(Set<? extends AlbumImageId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MdlAlbum.getImagesByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public AlbumId insertAlbum(DBAlbum album) {
        return (AlbumId)IbatisDAOUtil.wrappedInsert(this._sqlMapper, "MdlAlbum.insertAlbum", album);
    }

    @Override
    public AlbumImageId insertImage(DBAlbumImage image) {
        return (AlbumImageId)IbatisDAOUtil.wrappedInsert(this._sqlMapper, "MdlAlbum.insertImage", image);
    }

    @Override
    public void updateImage(DBAlbumImage image) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "MdlAlbum.updateImage", image);
    }

    @Override
    public void deleteAlbum(AlbumId albumId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "MdlAlbum.deleteAlbum", albumId);
    }

    @Override
    public void deleteImages(Set<AlbumImageId> imageIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "MdlAlbum.deleteImages", imageIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void updateAlbumDescription(AlbumId id, String description) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "MdlAlbum.updateAlbumDescription", ImmutableMap.of((Object)"id", (Object)id, (Object)"description", (Object)description));
    }

    @Override
    public void updateAlbumLocation(AlbumId id, String location) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "MdlAlbum.updateAlbumLocation", ImmutableMap.of((Object)"id", (Object)id, (Object)"location", (Object)location));
    }

    @Override
    public void updateAlbumTitle(AlbumId id, String title) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "MdlAlbum.updateAlbumTitle", ImmutableMap.of((Object)"id", (Object)id, (Object)"title", (Object)title));
    }

    @Override
    public void updateAlbumEditDate(AlbumId id) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "MdlAlbum.updateAlbumEditDate", id);
    }

    @Override
    public DBAlbum getNoModuleDBAlbumByParentId(GlobalId parentId) {
        List albums = IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "MdlAlbum.getNoModuleDBAlbumByParentId", parentId.asMap());
        return albums.isEmpty() ? null : (DBAlbum)albums.get(0);
    }

    @Override
    public DBAlbum getDefaultAlbum(GlobalId itemId) {
        return (DBAlbum)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "MdlAlbum.getDefaultAlbum", itemId.asMap());
    }

    @Override
    public void setDefaultAlbum(final GlobalId itemId, final AlbumId albumId) throws DAOException {
        this._txh.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisDAOUtil.wrappedDelete(IbatisAlbumDAO.this._sqlMapper, "MdlAlbum.removeDefaultAlbum", IbatisDAOUtil.toParamMapByType(itemId.asMap()));
                IbatisDAOUtil.wrappedInsert(IbatisAlbumDAO.this._sqlMapper, "MdlAlbum.setDefaultAlbum", IbatisDAOUtil.toParamMapByType(itemId.asMap(), albumId));
            }
        });
    }

    @Override
    public ImmutableList<DBAlbum> getAlbumsByParentIds(Set<? extends GlobalId> parentIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "MdlAlbum.getAlbumsByParentIds", parentIds, GlobalId.AS_MAP_LIST);
    }
}

