/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.business.ImageCommentedStreamHandler;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.ImageCommented;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imageCommentedStreamHandler")
public class ImageCommentedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<ImageCommented>
implements ImageCommentedStreamHandler {
    @Autowired
    private AlbumService _albumService;

    @Override
    public ImageCommented aggregate(ImageCommented oldEntry, ImageCommented newEntry) {
        if (oldEntry.getImageId().equals(newEntry.getImageId())) {
            return newEntry;
        }
        return null;
    }

    @Override
    public boolean isAggregatePossible() {
        return true;
    }

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return ImageCommentedStreamHandlerImpl.attributesToDelete(itemIds, "image_id", AlbumImageId.class);
    }

    @Override
    public ImageCommented convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        AlbumImageId imageId = AlbumImageId.parse(m.getAttribute("image_id"));
        DBAlbumImage image = imageId != null ? this._albumService.getDBImageById(imageId) : null;
        DBAlbum album = image != null ? this._albumService.getDBAlbumById(image.getAlbumId()) : null;
        return new ImageCommented(m, author, may, imageId, image != null ? image.getTitle() : "", image != null ? image.getAlbumId() : null, album != null ? album.getTitle() : null);
    }
}

