/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.business.events.AlbumCreatedEvent;
import de.justsoftware.onx.album.business.events.ImageCreatedEvent;
import de.justsoftware.onx.album.integration.persistence.AlbumDAO;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.Albums;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.album.shared.server.model.AlbumImageItem;
import de.justsoftware.onx.album.shared.server.model.AlbumItem;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.server.util.BeanUtil;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.document.business.DocumentService;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service(value="mdlAlbumService")
public class AlbumServiceImpl
implements AlbumService {
    private static final ImmutableSet<? extends Action> ALBUMS_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.ALBUM_CREATE, (Object)StaticAction.ALBUM_SHOW_ACTIONS);
    private static final ImmutableSet<? extends Action> ALBUM_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.ALBUM_DELETE, (Object)StaticAction.ALBUM_UPDATE, (Object)StaticAction.ALBUM_SHOW_ACTIONS, (Object)StaticAction.ALBUM_CREATE);
    private static final ImmutableSet<? extends Action> IMAGE_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.ALBUM_DELETE, (Object)StaticAction.ALBUM_UPDATE, (Object)StaticAction.ALBUM_SHOW_ACTIONS, (Object)StaticAction.COMMENT_CREATE);
    private static final int IMAGE_TEASER_COUNT = 3;
    private final ModuleAlbumsByParentCacheAccessor _moduleAlbumByParentCacheAccessor;
    private final AlbumByIdCacheAccessor _albumByIdCacheAccessor;
    private final ImageByAlbumCacheAccessor _imageByAlbumCacheAccessor;
    private final ImageByIdCacheAccessor _imageByIdCacheAccessor;
    private final AlbumDAO _albumDAO;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private StorageServerHelper _storageServerHelper;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private DocumentService _documentService;

    @Autowired
    @ParametersAreNonnullByDefault
    public AlbumServiceImpl(EhcacheClient cache, AlbumDAO albumDAO) {
        this._albumDAO = albumDAO;
        this._moduleAlbumByParentCacheAccessor = new ModuleAlbumsByParentCacheAccessor(cache, albumDAO);
        this._albumByIdCacheAccessor = new AlbumByIdCacheAccessor(cache, albumDAO);
        this._imageByAlbumCacheAccessor = new ImageByAlbumCacheAccessor(cache, albumDAO);
        this._imageByIdCacheAccessor = new ImageByIdCacheAccessor(cache, albumDAO);
    }

    @Override
    public ImmutableSet<AlbumId> getAlbumIdsByParentIds(Set<? extends GlobalId> parentIds) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this._albumDAO.getAlbumsByParentIds(parentIds), Identifiables.toId()));
    }

    @Override
    public ImmutableList<DBAlbumImage> getImagesByAlbumId(AlbumId albumId) {
        return (ImmutableList)this._imageByAlbumCacheAccessor.getSingle(albumId);
    }

    @Override
    public ImmutableListMultimap<AlbumId, DBAlbumImage> getImagesByAlbumIds(Set<AlbumId> albumIds) {
        return (ImmutableListMultimap)this._imageByAlbumCacheAccessor.getMultiMap(albumIds);
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
    }

    @Override
    public void create(ProfileItem parentProfileItem, ComponentType componentType, ServerEventCollector eventCollector) {
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) {
        return this.getAlbumsByParentId(entity, authorizationContext);
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, ProfileItem person, ComponentType componentType) {
        return this.getAlbumsByParentId(person, authorizationContext);
    }

    @Override
    public AlbumId insertDBAlbum(DBAlbum album, boolean createFeedMessage) {
        AlbumId result = this._albumDAO.insertAlbum(album);
        this._albumByIdCacheAccessor.invalidateKey(result);
        this._moduleAlbumByParentCacheAccessor.invalidateKey(album.getParentId());
        this._eventBus.post(new AlbumCreatedEvent(this.getDBAlbumById(result), createFeedMessage));
        return result;
    }

    @Override
    public AlbumImageId insertDBImage(AlbumId albumId, String title, String filename, PersonId ownerId, boolean generateFeedMessage) {
        DBAlbum album = this.getDBAlbumById(albumId);
        DBAlbumImage image = new DBAlbumImage(albumId, title, filename, ownerId);
        AlbumImageId result = this._albumDAO.insertImage(image);
        this._albumDAO.updateAlbumEditDate(albumId);
        this._imageByIdCacheAccessor.invalidateKey(result);
        this._albumByIdCacheAccessor.invalidateKey(albumId);
        this._imageByAlbumCacheAccessor.invalidateKey(albumId);
        if (album != null) {
            GlobalId parentId = album.getParentId();
            this._moduleAlbumByParentCacheAccessor.invalidateKey(parentId);
            if (album.isModule()) {
                this._eventBus.post(new ImageCreatedEvent(image, album, generateFeedMessage));
            }
        }
        return result;
    }

    @Override
    public void updateDBImage(DBAlbumImage image) {
        this._albumDAO.updateImage(image);
        this._imageByAlbumCacheAccessor.invalidateKey(image.getAlbumId());
        this._imageByIdCacheAccessor.invalidateKey(image.getId());
    }

    @Override
    public void deleteDBImage(AlbumImageId imageId, AuthorizationCheckContextWithUserId authCtx) {
        final DBAlbumImage dbImage = this.getDBImageById(imageId);
        if (dbImage == null) {
            return;
        }
        authCtx.check(AlbumImageItem.of(dbImage), (Action)StaticAction.ALBUM_DELETE);
        DeleteTransactionCallback callback = this._deletionService.deleteInTransactionWithDeleteAction(imageId, authCtx.getUserId(), new TransactionCallbackWithDeleteAction<DeleteTransactionCallback>(){

            @Override
            public DeleteTransactionCallback doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                return AlbumServiceImpl.this.deleteImages((Iterable<DBAlbumImage>)ImmutableList.of((Object)dbImage));
            }
        });
        callback.afterCommit();
        this._eventBus.post(new ItemDeletedEvent(imageId));
    }

    @Override
    public void deleteDependentImages(Set<AlbumImageId> imageIds, DeletionContext context) {
        if (!CollectionUtil.isEmpty(imageIds)) {
            context.attach(this.deleteDependentImages(imageIds));
        }
    }

    @Override
    public DeleteTransactionCallback deleteDependentImages(Set<AlbumImageId> imageIds) {
        if (CollectionUtil.isEmpty(imageIds)) {
            return DeleteTransactionCallback.DO_NOTHING_CALLBACK;
        }
        ImmutableCollection images = this._albumDAO.getImagesByIds(imageIds).values();
        return this.deleteImages((Iterable<DBAlbumImage>)images);
    }

    @Override
    public void deleteDependentAlbums(final Iterable<AlbumId> albumIds, final Set<? extends GlobalId> parentIds, DeletionContext context) {
        for (AlbumId albumId : albumIds) {
            this._albumDAO.deleteAlbum(albumId);
        }
        context.attach(new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                AlbumServiceImpl.this.invalidateAlbumCaches(albumIds, parentIds);
            }
        });
    }

    private void invalidateAlbumCaches(@Nonnull Iterable<AlbumId> albumIds, @Nonnull Set<? extends GlobalId> parentIds) {
        this._albumByIdCacheAccessor.invalidateKeys(albumIds);
        this._moduleAlbumByParentCacheAccessor.invalidateKeys(parentIds);
        this._imageByAlbumCacheAccessor.invalidateKeys(albumIds);
    }

    @Nonnull
    @CheckReturnValue
    private DeleteTransactionCallback deleteImages(final @Nonnull Iterable<DBAlbumImage> images) {
        this._albumDAO.deleteImages((Set<AlbumImageId>)ImmutableSet.copyOf((Iterable)Iterables.transform(images, DBAlbumImage.TO_ID)));
        final Iterable fileNames = Iterables.filter((Iterable)Iterables.transform(images, (Function)new Function<DBAlbumImage, String>(){

            public String apply(@Nullable DBAlbumImage input) {
                return input != null ? input.getFilename() : null;
            }
        }), (Predicate)Predicates.notNull());
        return new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                for (String fileName : fileNames) {
                    AlbumServiceImpl.this._storageServerHelper.deleteFileOnStorageServer(ImageType.MDL_ALBUM_IMAGE.getPath(), fileName);
                }
                AlbumServiceImpl.this.invalidateImageCaches(images);
            }
        };
    }

    private void invalidateImageCaches(@Nonnull Iterable<DBAlbumImage> images) {
        ImmutableSet albumIds = ImmutableSet.copyOf((Iterable)Iterables.transform(images, DBAlbumImage.GET_ALBUM_ID));
        ImmutableSet imageIds = ImmutableSet.copyOf((Iterable)Iterables.transform(images, DBAlbumImage.TO_ID));
        this._imageByAlbumCacheAccessor.invalidateKeys(albumIds);
        this._imageByIdCacheAccessor.invalidateKeys(imageIds);
    }

    @Override
    public void deleteDBAlbum(final AlbumId albumId, AuthorizationCheckContextWithUserId authCtx) {
        DBAlbum album = this.getDBAlbumById(albumId);
        if (album == null) {
            throw new InvalidIdServiceException();
        }
        authCtx.check(new AlbumItem(album), (Action)StaticAction.ALBUM_DELETE);
        this._deletionService.deleteInTransactionWithDeleteAction(albumId, authCtx.getUserId(), new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                AlbumServiceImpl.this._albumDAO.deleteAlbum(albumId);
                return this;
            }
        });
        this.invalidateAlbumCaches((Iterable<AlbumId>)ImmutableSet.of((Object)album.getId()), (Set<? extends GlobalId>)ImmutableSet.of((Object)album.getParentId()));
        this._eventBus.post(new ItemDeletedEvent(album.getId()));
    }

    @Nonnull
    private Iterable<AlbumImage> dbImageToImage(@Nonnull Iterable<DBAlbumImage> dbImages, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableMap map = Maps.uniqueIndex(dbImages, DBAlbumImage.TO_ID);
        ImmutableMap<AlbumImageId, AlbumImage> result = this.dbImageToImage((Map<AlbumImageId, DBAlbumImage>)map, authorizationContext);
        return Iterables.transform(dbImages, (Function)Functions.compose((Function)Functions.forMap(result), DBAlbumImage.TO_ID));
    }

    @Nonnull
    private ImmutableMap<AlbumImageId, AlbumImage> dbImageToImage(@Nonnull Map<AlbumImageId, DBAlbumImage> dbImages, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet ownerIds = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(dbImages.values(), DBAlbumImage.GET_OWNER), (Predicate)Predicates.notNull()));
        ImmutableMap<PersonId, PersonTeaserModel> owners = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)ownerIds, authorizationContext);
        ImmutableSet albumIds = ImmutableSet.copyOf((Iterable)Iterables.transform(dbImages.values(), DBAlbumImage.GET_ALBUM_ID));
        ImmutableMap<AlbumId, DBAlbum> albums = this.getDBAlbumsByIds((Set<AlbumId>)albumIds);
        ImmutableSetMultimap may = authorizationContext.may(Iterables.transform(dbImages.values(), AlbumImageItem.FROM_DBIMAGE), IMAGE_CHECK_ACTIONS);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (DBAlbumImage dbImage : dbImages.values()) {
            AlbumImageId imageId = dbImage.getId();
            AlbumImage image = BeanUtil.createBeanFromChildBean(AlbumImage.class, dbImage);
            image.setAuthor((PersonTeaserModel)owners.get((Object)dbImage.getOwnerId()));
            image.setMay((ImmutableSet<Action>)may.get((Object)Optional.of((Object)imageId)));
            image.setParentOfAlbum(((DBAlbum)albums.get((Object)dbImage.getAlbumId())).getParentId());
            String iconUrl = this._documentService.getIconUrl(dbImage.getFilename());
            image.setIconUrl(iconUrl);
            result.put((Object)imageId, (Object)image);
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMap<AlbumId, Album> dbAlbumToAlbum(@Nonnull Map<AlbumId, DBAlbum> albums, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet ownerIds = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(albums.values(), DBAlbum.GET_OWNER), (Predicate)Predicates.notNull()));
        ImmutableMap<PersonId, PersonTeaserModel> owners = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)ownerIds, authorizationContext);
        ImmutableSetMultimap<Optional<AlbumId>, ? extends Action> may = authorizationContext.mayByIds(albums.keySet(), ALBUM_CHECK_ACTIONS);
        ImmutableListMultimap images = (ImmutableListMultimap)this._imageByAlbumCacheAccessor.getMultiMap(albums.keySet());
        ImmutableMap.Builder oldestImageIdsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder oldestDBImages = ImmutableMap.builder();
        for (DBAlbum dbAlbum : albums.values()) {
            AlbumId albumId = dbAlbum.getId();
            ImmutableList imagesForAlbum = images.get((Object)albumId);
            if (imagesForAlbum.isEmpty()) continue;
            DBAlbumImage oldestImage = (DBAlbumImage)Ordering.natural().onResultOf(DBAlbumImage.GET_CREATE_DATE).min((Iterable)imagesForAlbum);
            oldestImageIdsBuilder.put((Object)albumId, (Object)oldestImage.getId());
            oldestDBImages.put((Object)oldestImage.getId(), (Object)oldestImage);
        }
        ImmutableMap<AlbumImageId, AlbumImage> oldestImages = this.dbImageToImage((Map<AlbumImageId, DBAlbumImage>)oldestDBImages.build(), authorizationContext);
        ImmutableMap oldestImageIds = oldestImageIdsBuilder.build();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (DBAlbum dbAlbum : albums.values()) {
            AlbumId albumId = dbAlbum.getId();
            Album album = BeanUtil.createBeanFromChildBean(Album.class, dbAlbum);
            album.setAlbumImage((AlbumImage)oldestImages.get(oldestImageIds.get((Object)albumId)));
            album.setImageCount(images.get((Object)albumId).size());
            album.setOwner((PersonTeaserModel)owners.get((Object)dbAlbum.getOwnerId()));
            album.setMay((Set<Action>)may.get((Object)Optional.of((Object)albumId)));
            result.put((Object)albumId, (Object)album);
        }
        return result.build();
    }

    @Override
    public ImmutableMap<AlbumId, DBAlbum> getDBAlbumsByIds(Set<AlbumId> ids) {
        return this._albumByIdCacheAccessor.getMap(ids);
    }

    @Override
    public ImmutableMap<AlbumImageId, DBAlbumImage> getDBImagesByIds(Set<AlbumImageId> ids) {
        return this._imageByIdCacheAccessor.getMap(ids);
    }

    @Override
    public DBAlbum getDBAlbumById(AlbumId albumId) {
        return (DBAlbum)this._albumByIdCacheAccessor.getSingle(albumId);
    }

    @Override
    public DBAlbumImage getDBImageById(AlbumImageId imageId) {
        return (DBAlbumImage)this._imageByIdCacheAccessor.getSingle(imageId);
    }

    @Override
    public Album getAlbumById(AlbumId albumId, AuthorizationContext authorizationContext) {
        DBAlbum album = this.getDBAlbumById(albumId);
        if (album == null) {
            return null;
        }
        return (Album)this.dbAlbumToAlbum((Map<AlbumId, DBAlbum>)ImmutableMap.of((Object)albumId, (Object)album), authorizationContext).get((Object)albumId);
    }

    @Override
    public DBAlbum getNoModuleDBAlbumByParentId(GlobalId parentId) throws InvalidIDException {
        DBAlbum album = this._albumDAO.getNoModuleDBAlbumByParentId(parentId);
        if (album == null) {
            DBAlbum newAlbum = new DBAlbum();
            newAlbum.setModule(false);
            newAlbum.setParentId(parentId);
            newAlbum.setTitle("");
            newAlbum.setLocation("");
            newAlbum.setDescription("");
            this.insertDBAlbum(newAlbum, false);
            return this._albumDAO.getNoModuleDBAlbumByParentId(parentId);
        }
        return album;
    }

    @Nonnull
    private ImmutableList<AlbumImage> getNewestImages(@Nonnull GlobalId parentId, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableListMultimap<AlbumId, DBAlbumImage> images = this.imagesOfParent(parentId);
        if (images.isEmpty()) {
            return ImmutableList.of();
        }
        List newestDbImages = Ordering.natural().onResultOf(DBAlbumImage.GET_EDIT_DATE).greatestOf((Iterable)images.values(), 3);
        return ImmutableList.copyOf(this.dbImageToImage(newestDbImages, authorizationContext));
    }

    @Override
    public ListAndCount<Album> getAlbumListByParentId(GlobalId itemId, int offset, int limit, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableList albums = (ImmutableList)this._moduleAlbumByParentCacheAccessor.getSingle(itemId);
        ListAndCount result = new ListAndCount(albums, offset, limit);
        ImmutableMap<AlbumId, Album> transformMap = this.dbAlbumToAlbum((Map<AlbumId, DBAlbum>)Maps.uniqueIndex(result, Identifiables.toId()), authorizationContext);
        return ListAndCount.transform(result, Functions.compose((Function)Functions.forMap(transformMap, null), Identifiables.toId()));
    }

    @Override
    public Albums getAlbumsByParentId(Item<? extends GlobalId> item, AuthorizationCheckContextWithLocale authorizationContext) {
        return new Albums((GlobalId)item.getId(), authorizationContext.may(item, ALBUMS_CHECK_ACTIONS), this.getNewestImages((GlobalId)item.getId(), authorizationContext));
    }

    @Override
    public ListAndCount<AlbumImage> getImageListByAlbumId(AlbumId albumId, int offset, int limit, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableList images = (ImmutableList)this._imageByAlbumCacheAccessor.getSingle(albumId);
        ListAndCount result = new ListAndCount(images, offset, limit);
        ImmutableMap<AlbumImageId, AlbumImage> transformMap = this.dbImageToImage((Map<AlbumImageId, DBAlbumImage>)Maps.uniqueIndex(result, DBAlbumImage.TO_ID), authorizationContext);
        return ListAndCount.transform(result, Functions.compose((Function)Functions.forMap(transformMap, null), DBAlbumImage.TO_ID));
    }

    @Override
    public void updateAlbumDescription(DBAlbum album, String description) {
        this._albumDAO.updateAlbumDescription(album.getId(), description);
        this._albumByIdCacheAccessor.invalidateKey(album.getId());
        this._moduleAlbumByParentCacheAccessor.invalidateKey(album.getParentId());
    }

    @Override
    public void updateAlbumLocation(DBAlbum album, String location) {
        this._albumDAO.updateAlbumLocation(album.getId(), location);
        this._albumByIdCacheAccessor.invalidateKey(album.getId());
        this._moduleAlbumByParentCacheAccessor.invalidateKey(album.getParentId());
    }

    @Override
    public void updateAlbumTitle(DBAlbum album, String title) {
        this._albumDAO.updateAlbumTitle(album.getId(), title);
        this._albumByIdCacheAccessor.invalidateKey(album.getId());
        this._moduleAlbumByParentCacheAccessor.invalidateKey(album.getParentId());
    }

    @Override
    public AlbumImage getImageById(AlbumImageId imageId, AuthorizationCheckContextWithLocale authCtx) {
        return (AlbumImage)this.getImageByIds((Set<AlbumImageId>)ImmutableSet.of((Object)imageId), authCtx).get((Object)imageId);
    }

    @Override
    public ImmutableMap<AlbumImageId, AlbumImage> getImageByIds(Set<AlbumImageId> imageIds, AuthorizationCheckContextWithLocale authorizationContext) {
        return this.dbImageToImage((Map<AlbumImageId, DBAlbumImage>)this.getDBImagesByIds(imageIds), authorizationContext);
    }

    @Override
    public DBAlbum getOrCreateDefaultAlbum(ItemId itemId) throws InvalidIDException {
        if (!(itemId instanceof GlobalId)) {
            throw new UnsupportedOperationException("albums need a global id as parent");
        }
        this._itemService.getByIdNonNull(itemId);
        final GlobalId globalId = (GlobalId)itemId;
        DBAlbum ret = this._albumDAO.getDefaultAlbum(globalId);
        if (ret != null) {
            return ret;
        }
        try {
            return InvalidIDException.check(globalId, this._transactionHelper.doInTransaction(new TransactionCallback<DBAlbum>(){

                public DBAlbum doInTransaction(TransactionStatus arg0) {
                    DBAlbum album = new DBAlbum();
                    album.setParentId(globalId);
                    album.setTitle("Album");
                    album.setDescription("");
                    album.setLocation("");
                    album.setModule(true);
                    AlbumId albumId = AlbumServiceImpl.this.insertDBAlbum(album, false);
                    AlbumServiceImpl.this.setDefaultAlbum(globalId, albumId);
                    return AlbumServiceImpl.this._albumDAO.getDefaultAlbum(globalId);
                }
            }));
        }
        catch (DAOException ex) {
            return InvalidIDException.check(globalId, this._albumDAO.getDefaultAlbum(globalId));
        }
    }

    private void setDefaultAlbum(GlobalId itemId, AlbumId albumId) throws DAOException {
        this._albumDAO.setDefaultAlbum(itemId, albumId);
    }

    @Override
    public int imageCountByParentId(GlobalId globalId) {
        return this.imagesOfParent(globalId).size();
    }

    @Nonnull
    private ImmutableListMultimap<AlbumId, DBAlbumImage> imagesOfParent(@Nonnull GlobalId globalId) {
        ImmutableList albums = (ImmutableList)this._moduleAlbumByParentCacheAccessor.getSingle(globalId);
        if (albums.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableMap albumMap = Maps.uniqueIndex((Iterable)albums, Identifiables.toId());
        return (ImmutableListMultimap)this._imageByAlbumCacheAccessor.getMultiMap(albumMap.keySet());
    }

    @Override
    public SaveImageResult uploadImage(InputStream in, PersonId personId, AlbumId album, String originalFilename) {
        String format = this._storageServerHelper.getFormatNameFromFilename(originalFilename);
        return this.uploadImage(in, format, personId, album, originalFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SaveImageResult uploadImage(InputStream in, String format, PersonId personId, AlbumId album, String originalFilename) {
        try {
            ImmutableSet sizes = ImmutableSet.of((Object)((Object)ImageSize.SMALL), (Object)((Object)ImageSize.BIG), (Object)((Object)ImageSize.ORIGINAL));
            String ext = this._storageServerHelper.getExtension(originalFilename);
            String random = SecureRandomUtil.randomHex();
            String albumIdPrefix = album != null ? album.getId() + "-" : "";
            String filename = albumIdPrefix + personId.getId() + "-" + random + ext;
            SaveImageResult saveImageResult = this._storageServerHelper.saveFileOnStorageServer(in, format, ImageType.MDL_ALBUM_IMAGE.getPath(), filename, (Collection<ImageSize>)sizes, false);
            return saveImageResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static enum AlbumServiceCacheName implements EhCacheName
    {
        ALBUM_BY_ID("MDL_ALBUM_BY_ID"),
        ALBUM_BY_PARENT("MDL_ALBUM_BY_PARENT"),
        IMAGE_BY_ALBUM("MDL_ALBUM_IMAGE_BY_ALBUM"),
        IMAGE_BY_ID("MDL_ALBUM_IMAGE_BY_ID");

        private final String _cacheName;

        private AlbumServiceCacheName(String cachename) {
            this._cacheName = cachename;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }

        @Override
        public int getMaxElements() {
            return 2000;
        }
    }

    private static final class ImageByIdCacheAccessor
    extends AbstractMapLoadingCacheAccessor<AlbumServiceCacheName, AlbumImageId, DBAlbumImage> {
        private final AlbumDAO _albumDAO;

        protected ImageByIdCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull AlbumDAO albumDAO) {
            super(cache, AlbumServiceCacheName.IMAGE_BY_ID);
            this._albumDAO = albumDAO;
        }

        @Override
        protected Map<AlbumImageId, DBAlbumImage> getFromDatabaseMulti(Set<? extends AlbumImageId> inputs) {
            return this._albumDAO.getImagesByIds(inputs);
        }

        @Override
        protected String keyToString(AlbumImageId key) {
            return key.asString();
        }

        @Override
        protected DBAlbumImage copyObject(DBAlbumImage o) {
            return ImageByIdCacheAccessor.fastCopy(o);
        }
    }

    private static final class ImageByAlbumCacheAccessor
    extends AbstractListMultiMapCacheAccessor<AlbumServiceCacheName, AlbumId, DBAlbumImage> {
        private final AlbumDAO _albumDAO;

        private ImageByAlbumCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull AlbumDAO albumDAO) {
            super(cache, AlbumServiceCacheName.IMAGE_BY_ALBUM);
            this._albumDAO = albumDAO;
        }

        @Override
        protected AlbumId objectToKey(DBAlbumImage dbResult) {
            return dbResult.getAlbumId();
        }

        @Override
        protected Iterable<DBAlbumImage> getListFromDatabase(Set<? extends AlbumId> inputs) {
            return this._albumDAO.getImagesByAlbumIds(inputs);
        }

        @Override
        protected String keyToString(AlbumId key) {
            return key.asString();
        }

        @Override
        protected Collection<DBAlbumImage> copyCollection(Collection<DBAlbumImage> o) {
            return ImageByAlbumCacheAccessor.fastCopy(o);
        }
    }

    private static final class AlbumByIdCacheAccessor
    extends AbstractMapLoadingCacheAccessor<AlbumServiceCacheName, AlbumId, DBAlbum> {
        private final AlbumDAO _albumDAO;

        protected AlbumByIdCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull AlbumDAO albumDAO) {
            super(cache, AlbumServiceCacheName.ALBUM_BY_ID);
            this._albumDAO = albumDAO;
        }

        @Override
        protected String keyToString(AlbumId key) {
            return key.asString();
        }

        @Override
        protected Map<AlbumId, DBAlbum> getFromDatabaseMulti(Set<? extends AlbumId> inputs) {
            return this._albumDAO.getAlbumsByIds(inputs);
        }

        @Override
        protected DBAlbum copyObject(DBAlbum o) {
            return AlbumByIdCacheAccessor.fastCopy(o);
        }
    }

    private static final class ModuleAlbumsByParentCacheAccessor
    extends AbstractListMultiMapCacheAccessor<AlbumServiceCacheName, GlobalId, DBAlbum> {
        private final AlbumDAO _albumDAO;

        private ModuleAlbumsByParentCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull AlbumDAO albumDAO) {
            super(cache, AlbumServiceCacheName.ALBUM_BY_PARENT);
            this._albumDAO = albumDAO;
        }

        @Override
        protected GlobalId objectToKey(DBAlbum dbResult) {
            return dbResult.getParentId();
        }

        @Override
        protected Iterable<? extends DBAlbum> getListFromDatabase(Set<? extends GlobalId> inputs) {
            return Iterables.filter(this._albumDAO.getAlbumsByParentIds(inputs), DBAlbum.IS_MODULE);
        }

        @Override
        protected String keyToString(GlobalId key) {
            return key.asString();
        }

        @Override
        protected Collection<DBAlbum> copyCollection(Collection<DBAlbum> o) {
            return ModuleAlbumsByParentCacheAccessor.fastCopy(o);
        }
    }
}

