/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business;

import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.Albums;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.business.ProfileModuleHandler;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AlbumService
extends EntityModuleHandler,
ProfileModuleHandler {
    public DBAlbum getOrCreateDefaultAlbum(ItemId var1) throws InvalidIDException;

    @CheckForNull
    public DBAlbum getDBAlbumById(@Nonnull AlbumId var1);

    @CheckForNull
    public DBAlbumImage getDBImageById(@Nonnull AlbumImageId var1);

    @Nonnull
    public ImmutableMap<AlbumId, DBAlbum> getDBAlbumsByIds(@Nonnull Set<AlbumId> var1);

    @Nonnull
    public ImmutableMap<AlbumImageId, DBAlbumImage> getDBImagesByIds(@Nonnull Set<AlbumImageId> var1);

    @Nonnull
    public AlbumImageId insertDBImage(@Nonnull AlbumId var1, @Nonnull String var2, @Nonnull String var3, @Nonnull PersonId var4, boolean var5);

    public void deleteDBImage(@Nonnull AlbumImageId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    public void deleteDependentImages(@Nonnull Set<AlbumImageId> var1, @Nonnull DeletionContext var2);

    public void deleteDependentAlbums(@Nonnull Iterable<AlbumId> var1, @Nonnull Set<? extends GlobalId> var2, @Nonnull DeletionContext var3);

    public void deleteDBAlbum(@Nonnull AlbumId var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    public AlbumId insertDBAlbum(DBAlbum var1, boolean var2);

    public void updateDBImage(DBAlbumImage var1);

    public ListAndCount<Album> getAlbumListByParentId(GlobalId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithLocale var4);

    public int imageCountByParentId(@Nonnull GlobalId var1);

    public Albums getAlbumsByParentId(@Nonnull Item<? extends GlobalId> var1, @Nonnull AuthorizationCheckContextWithLocale var2) throws InvalidIDException;

    public ListAndCount<AlbumImage> getImageListByAlbumId(AlbumId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithLocale var4);

    public void updateAlbumDescription(@Nonnull DBAlbum var1, @Nonnull String var2);

    public void updateAlbumLocation(@Nonnull DBAlbum var1, String var2);

    public void updateAlbumTitle(@Nonnull DBAlbum var1, String var2);

    @Nonnull
    public ImmutableList<DBAlbumImage> getImagesByAlbumId(@Nonnull AlbumId var1);

    @Nonnull
    public ImmutableListMultimap<AlbumId, DBAlbumImage> getImagesByAlbumIds(@Nonnull Set<AlbumId> var1);

    @Nonnull
    public DBAlbum getNoModuleDBAlbumByParentId(GlobalId var1) throws InvalidIDException;

    public AlbumImage getImageById(@Nonnull AlbumImageId var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableMap<AlbumImageId, AlbumImage> getImageByIds(@Nonnull Set<AlbumImageId> var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public SaveImageResult uploadImage(@Nonnull InputStream var1, @Nonnull String var2, @Nonnull PersonId var3, @Nullable AlbumId var4, @Nonnull String var5);

    public SaveImageResult uploadImage(InputStream var1, PersonId var2, AlbumId var3, String var4);

    @Nonnull
    public ImmutableSet<AlbumId> getAlbumIdsByParentIds(@Nonnull Set<? extends GlobalId> var1);

    @CheckForNull
    public Album getAlbumById(@Nonnull AlbumId var1, @Nonnull AuthorizationContext var2);

    @Nonnull
    @CheckReturnValue
    public DeleteTransactionCallback deleteDependentImages(@Nonnull Set<AlbumImageId> var1);
}

