/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.administration.business.impl;

import com.freiheit.superoperty.Property;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Charsets;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"production"})
@ParametersAreNonnullByDefault
public class HostPropertiesToZookeeperCloner {
    private static final String JUST_CONFIG_PATH = "/just/config/";
    private static final String FEATURE_TOGGLES_PATH = "/just/config/common/features/";
    private static final Logger LOG = LoggerFactory.getLogger(HostPropertiesToZookeeperCloner.class);
    private final CuratorFramework _zookeeperClient;
    private final Settings _settings;

    @Autowired
    public HostPropertiesToZookeeperCloner(CuratorFramework zookeeperClient, Settings settings) {
        this._zookeeperClient = zookeeperClient;
        this._settings = settings;
    }

    private void storeInZookeeper(String path, String data) {
        ACLBackgroundPathAndBytesable createBuilder = (ACLBackgroundPathAndBytesable)this._zookeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
        SetDataBuilder updateBuilder = this._zookeeperClient.setData();
        try {
            createBuilder.forPath(path, data.getBytes(Charsets.UTF_8));
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                updateBuilder.forPath(path, data.getBytes(Charsets.UTF_8));
            }
            catch (Exception e1) {
                LOG.warn("Can not update " + path + " in zookeeper", (Throwable)e1);
            }
        }
        catch (Exception e) {
            LOG.warn("Can not create " + path + " in zookeeper", (Throwable)e);
        }
    }

    private void deleteFromZookeeper(String path) {
        BackgroundVersionable deleteBuilder = ((ChildrenDeletable)this._zookeeperClient.delete().guaranteed()).deletingChildrenIfNeeded();
        try {
            deleteBuilder.forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            LOG.warn("Can not delete " + path + " in zookeeper", (Throwable)e);
        }
    }

    private void publishFeatureToggleChanges(String name, Property property) {
        this.publishPropertyChanges(FEATURE_TOGGLES_PATH + name, property);
    }

    private void publishPropertyChanges(String path, Property property) {
        property.addSuperopertyChangeListener(event -> this.storeInZookeeper(path, event.getNewStringValue()));
        this.storeInZookeeper(path, property.getStringValue());
    }

    @PostConstruct
    public void copyProperties() {
        if (this._zookeeperClient == null) {
            LOG.warn("No zookeeper configured. Can not clone host properties and Superoperty into zookeeper.");
            return;
        }
        this.publishPropertyChanges("/just/config/common/ada/ssoConfigEnabled", this._settings.getAdaSSOConfigEnabled());
        this.publishPropertyChanges("/just/drive/publicLinksEnabled", this._settings.drivePublicLinksEnabled());
        this.publishPropertyChanges("/just/drive/historyCompactorCron", this._settings.getHistoryCompactorCron());
        this.publishPropertyChanges("/just/config/common/drive/upload/uploadMaxFileSize", this._settings.driveUploadMaxFileSize());
        this.publishPropertyChanges("/just/config/common/drive/upload/allowedMimeTypes", this._settings.driveUploadAllowedMimeTypes());
        this.publishPropertyChanges("/just/notification/mailCron", this._settings.getNotificationMailCronProperty());
        this.publishPropertyChanges("/just/chat/mailCron", this._settings.getNewChatMessagesEmailSenderCronExpr());
        this.publishPropertyChanges("/just/chat/cleanupAfter", this._settings.getCleanupChatsAfter());
        this.publishPropertyChanges("/just/wiki/cleanupAfter", this._settings.getCleanupWikiAfter());
        this.publishPropertyChanges("/just/config/common/adfsEnabled", this._settings.getAdfsEnabledProperty());
        this.publishPropertyChanges("/just/config/common/importPersonsEnabled", this._settings.getImportPersonsEnabledProperty());
        this.publishPropertyChanges("/just/config/common/piwik/piwikUrl", this._settings.getPiwikUrlProperty());
        this.publishPropertyChanges("/just/config/common/piwik/siteId", this._settings.getPiwikSiteIdProperty());
        this.publishPropertyChanges("/just/config/common/piwik/tokenAuth", this._settings.getPiwikTokenAuthProperty());
        this.publishPropertyChanges("/just/config/common/piwik/mobileTrackingEnabled", this._settings.getMobileTrackingEnabledProperty());
        this.publishPropertyChanges("/just/browser-push/browserPushServiceEnabled", this._settings.getBrowserPushServiceEnabledProperty());
        this.publishPropertyChanges("/just/config/common/adfsLoginEnabled", this._settings.isAdfsEnabledProperty());
        this.publishPropertyChanges("/just/config/common/news/deletionDelay", this._settings.getNewsDeletionDelay());
        this.publishPropertyChanges("/just/config/common/drive/deletionDelay", this._settings.getDriveDeletionDelay());
        this.deleteOldPaths();
    }

    private void deleteOldPaths() {
        if (this._zookeeperClient == null) {
            return;
        }
        this.deleteFromZookeeper("/just/url/protocol");
        this.deleteFromZookeeper("/just/url/domain");
        this.deleteFromZookeeper("/just/features/drive/sync");
        this.deleteFromZookeeper("/just/features/drive/createEmptyFile");
        this.deleteFromZookeeper("/just/config/common/features/drive/sync");
        this.deleteFromZookeeper("/just/config/common/features/drive/createEmptyFile");
        this.deleteFromZookeeper("/just/drive/sync/jwtKey");
        this.deleteFromZookeeper("/just/config/common/features/judo/videoConversionEnabled");
        this.deleteFromZookeeper("/just/config/common/features/people/groupsEnabled");
        this.deleteFromZookeeper("/just/config/common/features/oAuthResourceServerEnabled");
        this.deleteFromZookeeper("/just/config/common/features/vsl/profileVSLEnabled");
        this.deleteFromZookeeper("/just/config/common/features/people/fieldSearchEnabled");
        this.deleteFromZookeeper("/just/config/common/people/groupsEnabled");
        this.deleteFromZookeeper("/just/drive/mergeChangesCron");
        this.deleteFromZookeeper("/just/config/common/features/news/snowballEnabled");
        this.deleteFromZookeeper("/just/config/common/features/admin/adminTenantManagementEnabled");
        this.deleteFromZookeeper("/just/config/common/newLoginPageEnabled");
        this.deleteFromZookeeper("/just/url/systemDomainPrefix");
        this.deleteFromZookeeper("/just/drive/uploadMaxFileSize");
    }
}

