/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.mail.EmailAttachment;
import de.justsoftware.mail.freemarker.EmbedImage;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.IMailTemplateRenderContext;
import java.nio.charset.Charset;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTimeZone;

public class MailTemplateRenderContext
implements IMailTemplateRenderContext {
    private final DateTimeZone _timeZone;
    private final ImmutableSet.Builder<EmailAttachment> _attachments;
    private final EmbedImage _embedImage;
    private final Charset _charset;
    private final FreemarkerRenderMode _renderType;

    @ParametersAreNonnullByDefault
    MailTemplateRenderContext(FreemarkerRenderMode renderType, EmbedImage embedImage, DateTimeZone timeZone, Charset charset, ImmutableSet.Builder<EmailAttachment> attachments) {
        this._renderType = renderType;
        this._embedImage = embedImage;
        this._timeZone = timeZone;
        this._charset = charset;
        this._attachments = attachments;
    }

    @Override
    public DateTimeZone getTimeZone() {
        return this._timeZone;
    }

    @Override
    public void addAttachment(EmailAttachment attachment) {
        this._attachments.add((Object)attachment);
    }

    @Override
    public EmbedImage getEmbedImage() {
        return this._embedImage;
    }

    @Override
    public Charset getCharset() {
        return this._charset;
    }

    @Override
    public FreemarkerRenderMode getRenderMode() {
        return this._renderType;
    }
}

