/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class FreemarkerDateFormatDirective
extends SimpleFreemarkerDirective {
    public static final FreemarkerDateFormatDirective INSTANCE = new FreemarkerDateFormatDirective();
    public static final String NAME = "date";
    private static final DateTimeFormatter SHORT_DATE_FORMAT = DateTimeFormat.shortDate();
    private static final DateTimeFormatter SHORT_DATETIME_FORMAT = DateTimeFormat.shortDateTime();
    private static final DateTimeFormatter SHORT_TIME_FORMAT = DateTimeFormat.shortTime();
    private static final DateTimeFormatter LONG_DATE_FORMAT = DateTimeFormat.longDate();
    private static final DateTimeFormatter LONG_DATE_TIME_FORMAT = DateTimeFormat.longDateTime();
    private static final DateTimeFormatter LONG_TIME_FORMAT = DateTimeFormat.longTime();

    @Override
    protected String loadString(Map<String, ?> params, Environment environment) throws TemplateException, IOException {
        String format = FreemarkerDirectiveUtils.getStringParameter("format", params, "shortDate", environment);
        DateTimeFormatter formatter = "shortDateTime".equalsIgnoreCase(format) ? SHORT_DATETIME_FORMAT : ("shortTime".equalsIgnoreCase(format) ? SHORT_TIME_FORMAT : ("longDate".equalsIgnoreCase(format) ? LONG_DATE_FORMAT : ("longDateTime".equalsIgnoreCase(format) ? LONG_DATE_TIME_FORMAT : ("longTime".equalsIgnoreCase(format) ? LONG_TIME_FORMAT : SHORT_DATE_FORMAT))));
        return FreemarkerDirectiveUtils.escape(environment, formatter.withLocale(environment.getLocale()).withZone(FreemarkerDirectiveUtils.getContext(environment).getTimeZone()).print((ReadableInstant)FreemarkerDirectiveUtils.getValue(DateTime.class, "value", params, environment)));
    }
}

