/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import de.justsoftware.mail.EmbeddedEmailAttachment;
import de.justsoftware.mail.freemarker.EmbedImage;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.IMailTemplateRenderContext;
import freemarker.core.Environment;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedImageBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedImageBuilder.class);
    private String _mimeType = null;
    private ByteSource _attachmentData = null;
    private String _externalUrl = null;
    private final String _filename;
    private final IMailTemplateRenderContext _context;

    EmbeddedImageBuilder(@Nonnull Environment environment, @Nonnull String filename) {
        this._context = FreemarkerDirectiveUtils.getContext(environment);
        this._filename = filename;
    }

    @Nonnull
    public EmbeddedImageBuilder setContentType(@Nonnull String mimeType) {
        this._mimeType = mimeType;
        return this;
    }

    @Nonnull
    public EmbeddedImageBuilder setAttachmentData(@Nonnull ByteSource attachmentData) {
        this._attachmentData = attachmentData;
        return this;
    }

    @Nonnull
    public EmbeddedImageBuilder setExternalUrl(@Nonnull String externalUrl) {
        this._externalUrl = externalUrl;
        return this;
    }

    @CheckForNull
    public String buildAndReturnNewUrl() throws IOException {
        byte[] bytes;
        if (this._attachmentData == null) {
            return this._externalUrl;
        }
        try {
            bytes = this._attachmentData.read();
        }
        catch (IOException e) {
            LOG.warn("error reading image, returning external url \"" + this._externalUrl + "\"", (Throwable)e);
            return this._externalUrl;
        }
        return this._context.getEmbedImage().accept(new EmbedImage.EmbedImageVisitor<String, IOException>(){

            @Nonnull
            public String getMimeTypeInternal() {
                return EmbeddedImageBuilder.this._mimeType != null ? EmbeddedImageBuilder.this._mimeType : EmbeddedImageBuilder.guessMimeType(EmbeddedImageBuilder.this._filename);
            }

            @Override
            public String visitContentId() {
                EmbeddedEmailAttachment attachment = new EmbeddedEmailAttachment(ByteSource.wrap((byte[])bytes), EmbeddedImageBuilder.this._filename, this.getMimeTypeInternal());
                EmbeddedImageBuilder.this._context.addAttachment(attachment);
                return "cid:" + attachment.getContentId();
            }

            @Override
            public String visitBase64Data() throws IOException {
                return "data:" + this.getMimeTypeInternal() + ";base64," + new String(Base64.encodeBase64((byte[])bytes), Charsets.UTF_8);
            }

            @Override
            public String visitExternal() throws IOException {
                return EmbeddedImageBuilder.this._externalUrl != null ? EmbeddedImageBuilder.this._externalUrl : this.visitContentId();
            }
        });
    }

    @Nonnull
    @VisibleForTesting
    static String guessMimeType(@Nullable String filename) {
        String filenameWithoutQuery = StringUtils.substringBeforeLast((String)filename, (String)"?");
        if (StringUtils.endsWithIgnoreCase((String)filenameWithoutQuery, (String)"jpg") || StringUtils.endsWithIgnoreCase((String)filenameWithoutQuery, (String)".jpeg") || StringUtils.endsWithIgnoreCase((String)filenameWithoutQuery, (String)".jpe")) {
            return "image/jpeg";
        }
        if (StringUtils.endsWithIgnoreCase((String)filenameWithoutQuery, (String)"gif")) {
            return "image/gif";
        }
        if (StringUtils.endsWithIgnoreCase((String)filenameWithoutQuery, (String)"png")) {
            return "image/png";
        }
        return "application/octet-stream";
    }

    @Nonnull
    public static EmbeddedImageBuilder create(@Nonnull Environment environment, @Nonnull String filename) {
        return new EmbeddedImageBuilder(environment, filename);
    }
}

