/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail;

import com.google.common.base.Objects;
import com.google.common.io.ByteSource;
import de.justsoftware.mail.EmailAttachment;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractAttachment
implements EmailAttachment {
    private final String _fileName;
    private final String _contentType;
    private final ByteSource _attachmentData;

    protected AbstractAttachment(@Nonnull ByteSource attachmentData, @Nonnull String fileName, @Nonnull String contentType) {
        this._attachmentData = attachmentData;
        this._contentType = contentType;
        this._fileName = fileName;
    }

    @Override
    public ByteSource getAttachmentData() {
        return this._attachmentData;
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public String getFileName() {
        String basename = FilenameUtils.getName((String)this._fileName).replace('?', '_');
        String contentId = this.getContentId();
        return contentId != null ? contentId + "_" + basename : basename;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmailAttachment)) {
            return false;
        }
        String ocid = ((EmailAttachment)obj).getContentId();
        String contentId = this.getContentId();
        return contentId != null && ocid != null && contentId.equals(ocid);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getContentId()});
    }
}

