/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.common.fastcopy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.SerializationUtils;

public class FastCopyUtils {
    @VisibleForTesting
    static final Map<Class<?>, ClassCopyCommand<?>> TYPE_INFO = FastCopyUtils.createDefaultMap();

    @Nonnull
    private static <T> T insertNewObjectAndReturn(@Nonnull Object src, @Nonnull T newObject, @Nonnull Map<Integer, Object> objects) {
        objects.put(System.identityHashCode(src), newObject);
        return newObject;
    }

    @Nonnull
    private static Map<Class<?>, ClassCopyCommand<?>> createDefaultMap() {
        Class[] immutableTypes;
        ConcurrentMap result = Maps.newConcurrentMap();
        for (Class clz : immutableTypes = new Class[]{String.class, Boolean.class, Class.class, Character.class, Byte.class, Integer.class, Short.class, Long.class, Double.class, Float.class, Enum.class, BigDecimal.class, BigInteger.class}) {
            result.put(clz, ClassCopyCommands.IMMUTABLE_FINAL);
        }
        return result;
    }

    @CheckForNull
    public static <T> T copyNullable(@Nullable T object) throws FastCopyException {
        return FastCopyUtils.copyNullable(object, Maps.newHashMap());
    }

    @CheckForNull
    private static <T> T copyNullable(@Nullable T object, @Nonnull Map<Integer, Object> objects) throws FastCopyException {
        return object != null ? (T)FastCopyUtils.copy(object, objects) : null;
    }

    @Nonnull
    public static <T> T copy(@Nonnull T object) throws FastCopyException {
        return FastCopyUtils.copy(object, Maps.newHashMap());
    }

    @Nonnull
    private static <T> T copy(@Nonnull T object, @Nonnull Map<Integer, Object> objects) throws FastCopyException {
        Integer identityHashCode = System.identityHashCode(object);
        Object existing = objects.get(identityHashCode);
        if (existing != null) {
            return (T)existing;
        }
        return FastCopyUtils.getCopyCommand(object).copy(object, objects);
    }

    @Nonnull
    private static <T> ClassCopyCommand<T> getCopyCommand(@Nonnull T object) {
        Class<?> clz = object.getClass();
        HashSet currentClasses = Sets.newHashSet();
        return FastCopyUtils.getCopyCommand(clz, currentClasses);
    }

    @Nonnull
    private static <T> ClassCopyCommand<T> getCopyCommand(@Nonnull Class<? extends T> clz, @Nonnull Set<Class<?>> currentClasses) {
        ClassCopyCommand<?> result = TYPE_INFO.get(clz);
        if (result != null) {
            return result;
        }
        ClassCopyCommand<? extends T> newResult = FastCopyUtils.createCopyCommand(clz, currentClasses);
        TYPE_INFO.put(clz, newResult);
        return newResult;
    }

    @Nonnull
    private static ImmutableList<Field> getAllfields(@Nonnull Class<?> clz) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Class<?> current = clz; current != null; current = current.getSuperclass()) {
            for (Field f : clz.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                result.add((Object)f);
            }
        }
        return result.build();
    }

    @Nonnull
    private static <T> ClassCopyCommand<T> createCopyCommand(@Nonnull Class<? extends T> clz, @Nonnull Set<Class<?>> currentClasses) {
        if (clz.isArray()) {
            return ClassCopyCommands.ARRAY.cast();
        }
        if (clz.isPrimitive() || Enum.class.isAssignableFrom(clz)) {
            return ClassCopyCommands.IMMUTABLE_FINAL.cast();
        }
        ImmutableList<Field> allfields = FastCopyUtils.getAllfields(clz);
        ClassCopyCommand<T> mutableCopyCommand = FastCopyUtils.createMutableCopyCommand(clz, allfields);
        if (!currentClasses.add(clz)) {
            return mutableCopyCommand;
        }
        for (Field f : allfields) {
            if (!Modifier.isFinal(f.getModifiers())) {
                return mutableCopyCommand;
            }
            if (!f.getType().isInterface() && ClassCopyCommands.IMMUTABLE_FINAL.equals(FastCopyUtils.getCopyCommand(f.getType(), currentClasses))) continue;
            return mutableCopyCommand;
        }
        return (Modifier.isFinal(clz.getModifiers()) ? ClassCopyCommands.IMMUTABLE_FINAL : ClassCopyCommands.IMMUTABLE).cast();
    }

    @Nonnull
    private static <T> ClassCopyCommand<T> createMutableCopyCommand(@Nonnull Class<? extends T> clz, @Nonnull ImmutableList<Field> allfields) {
        if (Cloneable.class.isAssignableFrom(clz)) {
            try {
                Method cloneMethod = clz.getMethod("clone", new Class[0]);
                cloneMethod.setAccessible(true);
                return new CloneClassCopyCommand(cloneMethod);
            }
            catch (SecurityException cloneMethod) {
            }
            catch (NoSuchMethodException cloneMethod) {
                // empty catch block
            }
        }
        if (Serializable.class.isAssignableFrom(clz)) {
            return ClassCopyCommands.SERIALIZE.cast();
        }
        try {
            Constructor<T> constructor = clz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return new MutableCopyCommand<T>(constructor, allfields);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("No Copy implementation found for " + clz);
    }

    private static class MutableCopyCommand<T>
    implements ClassCopyCommand<T> {
        private final ImmutableList<Field> _fields;
        private final Constructor<? extends T> _constructor;

        MutableCopyCommand(@Nonnull Constructor<? extends T> constructor, @Nonnull ImmutableList<Field> fields) {
            this._constructor = constructor;
            this._fields = MutableCopyCommand.setAccessible(fields);
        }

        @Nonnull
        private static ImmutableList<Field> setAccessible(@Nonnull ImmutableList<Field> fields) {
            for (Field f : fields) {
                f.setAccessible(true);
            }
            return fields;
        }

        @Override
        public T copy(T src, Map<Integer, Object> objects) throws FastCopyException {
            try {
                T result = FastCopyUtils.insertNewObjectAndReturn(src, this._constructor.newInstance(new Object[0]), objects);
                for (Field f : this._fields) {
                    f.set(result, FastCopyUtils.copyNullable(f.get(src), objects));
                }
                return result;
            }
            catch (RuntimeException e) {
                throw new FastCopyException(e);
            }
            catch (IllegalAccessException e) {
                throw new FastCopyException(e);
            }
            catch (InvocationTargetException e) {
                throw new FastCopyException(e);
            }
            catch (InstantiationException e) {
                throw new FastCopyException(e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static enum ClassCopyCommands implements ClassCopyCommand<Object>
    {
        IMMUTABLE{

            @Override
            public Object copy(Object src, Map<Integer, Object> objects) {
                return FastCopyUtils.insertNewObjectAndReturn(src, src, objects);
            }
        }
        ,
        IMMUTABLE_FINAL{

            @Override
            public Object copy(Object src, Map<Integer, Object> objects) {
                return FastCopyUtils.insertNewObjectAndReturn(src, src, objects);
            }
        }
        ,
        ARRAY{

            @Override
            public Object copy(Object src, Map<Integer, Object> objects) throws FastCopyException {
                try {
                    Class<?> componentType = src.getClass().getComponentType();
                    int length = Array.getLength(src);
                    Object result = FastCopyUtils.insertNewObjectAndReturn(src, Array.newInstance(componentType, length), objects);
                    for (int i = 0; i < length; ++i) {
                        Array.set(result, i, FastCopyUtils.copyNullable(Array.get(src, i), objects));
                    }
                    return result;
                }
                catch (RuntimeException e) {
                    throw new FastCopyException(e);
                }
            }
        }
        ,
        SERIALIZE{

            @Override
            public Object copy(Object src, Map<Integer, Object> objects) {
                return FastCopyUtils.insertNewObjectAndReturn(src, SerializationUtils.clone((Serializable)((Serializable)src)), objects);
            }
        };


        @Nonnull
        <T> ClassCopyCommand<T> cast() {
            return this;
        }
    }

    private static interface ClassCopyCommand<O> {
        @Nonnull
        public O copy(@Nonnull O var1, @Nonnull Map<Integer, Object> var2) throws FastCopyException;
    }

    private static final class CloneClassCopyCommand<T>
    implements ClassCopyCommand<T> {
        private final Method _cloneMethod;

        private CloneClassCopyCommand(@Nonnull Method cloneMethod) {
            this._cloneMethod = cloneMethod;
        }

        @Override
        public T copy(T src, Map<Integer, Object> objects) throws FastCopyException {
            try {
                return (T)FastCopyUtils.insertNewObjectAndReturn(src, this._cloneMethod.invoke(src, new Object[0]), objects);
            }
            catch (RuntimeException e) {
                throw new FastCopyException(e);
            }
            catch (IllegalAccessException e) {
                throw new FastCopyException(e);
            }
            catch (InvocationTargetException e) {
                throw new FastCopyException(e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static final class FastCopyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FastCopyException(@Nonnull Exception e) {
            super(e);
        }
    }
}

