/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.common.concurent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.BooleanUtils;

public final class CollectedBooleanFuture
implements Future<Boolean> {
    private final Iterable<? extends Future<? extends Boolean>> _futures;

    public CollectedBooleanFuture(Iterable<? extends Future<? extends Boolean>> futures) {
        this._futures = futures;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = true;
        for (Future<? extends Boolean> future : this._futures) {
            result &= future.cancel(mayInterruptIfRunning);
        }
        return result;
    }

    @Override
    public boolean isCancelled() {
        for (Future<? extends Boolean> future : this._futures) {
            if (!future.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        for (Future<? extends Boolean> future : this._futures) {
            if (!future.isDone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        boolean result = true;
        for (Future<? extends Boolean> future : this._futures) {
            result &= BooleanUtils.isTrue((Boolean)future.get());
        }
        return result;
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        boolean result = true;
        for (Future<? extends Boolean> future : this._futures) {
            long remainingTimeout = end - System.currentTimeMillis();
            if (remainingTimeout <= 0L) {
                throw new TimeoutException();
            }
            result &= BooleanUtils.isTrue((Boolean)future.get(remainingTimeout, TimeUnit.MILLISECONDS));
        }
        return result;
    }
}

