/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.ClientHttpPostRequest;
import com.freiheit.toro.common.shared.server.storage.AbstractStorageServerHelper;
import com.google.common.base.Charsets;
import de.justsoftware.onx.common.business.StorageServerConfig;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;

@Service(value="storageServerHelper")
public class StorageServerHelperImpl
extends AbstractStorageServerHelper {
    private static final String DELETE_FILE_ACTION = "deleteFile";
    private static final String TRASH_FILE_ACTION = "trashFile";
    private static final Logger LOG = LoggerFactory.getLogger(StorageServerHelperImpl.class);
    private static final float IMAGE_QUALITY = 0.9f;
    private final StorageServerConfig _storageServerConfig;
    private final RestOperations _restTemplate;

    @Autowired
    public StorageServerHelperImpl(@Nonnull Settings settings, @Nonnull StorageServerConfig storageServerConfig, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        super(settings);
        this._storageServerConfig = storageServerConfig;
        this._restTemplate = restTemplate;
    }

    @Override
    public void checkHealth() {
        try {
            this._restTemplate.getForEntity(this._storageServerConfig.getStorageServerUrl() + "internal/monitoring/health", JsonNode.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ServiceException("Storageserver health check returned status: " + e.getMessage() + " (" + e.getResponseBodyAsString() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveGenericFileOnStorageServer(InputStream input, String basePath, String newFilename) {
        String string;
        BufferedReader reader = null;
        InputStream in = null;
        try {
            ClientHttpPostRequest httpPost = new ClientHttpPostRequest(this.getStorageServerUploadService());
            httpPost.setParameter("action", "saveFile");
            httpPost.setParameter("basePath", basePath);
            httpPost.setParameter("fileStream", newFilename, input);
            in = httpPost.post();
            reader = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
            string = this.readAndConcatenateLines(reader);
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException e) {
            String string2 = e.getMessage();
            return string2;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly((InputStream)input);
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)input);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String saveImageFile(BufferedImage toSave, String formatType, String fullBasePath, String filename) {
        String string;
        BufferedReader reader = null;
        ByteArrayOutputStream imageOutputStream = null;
        ByteArrayInputStream imageInputStream = null;
        try {
            ClientHttpPostRequest httpPost = new ClientHttpPostRequest(this.getStorageServerUploadService());
            httpPost.setParameter("action", "saveFile");
            httpPost.setParameter("basePath", fullBasePath);
            imageOutputStream = new ByteArrayOutputStream();
            Thumbnails.of((BufferedImage[])new BufferedImage[]{toSave}).outputQuality(0.9f).scale(1.0).outputFormat(formatType).toOutputStream((OutputStream)imageOutputStream);
            imageInputStream = new ByteArrayInputStream(imageOutputStream.toByteArray());
            httpPost.setParameter("fileStream", filename, imageInputStream);
            InputStream in = httpPost.post();
            reader = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
            string = this.readAndConcatenateLines(reader);
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException e) {
            String string2 = e.getMessage();
            return string2;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(imageOutputStream);
            IOUtils.closeQuietly(imageInputStream);
        }
        IOUtils.closeQuietly((OutputStream)imageOutputStream);
        IOUtils.closeQuietly((InputStream)imageInputStream);
        return string;
    }

    @Override
    public String deleteGenericFileOnStorageServer(String fullBasePath, String filename) {
        return this.internalDeleteGenericFileOnStorageServer(fullBasePath, filename, false);
    }

    @Override
    public String deleteGenericFileOnStorageServerPermanently(String fullBasePath, String filename) {
        return this.internalDeleteGenericFileOnStorageServer(fullBasePath, filename, true);
    }

    @CheckForNull
    private String internalDeleteGenericFileOnStorageServer(String fullBasePath, String filename, boolean permanently) {
        if (!permanently && this._storageServerConfig.isTrashEnabled()) {
            return this.trashFileOnStorageServer(fullBasePath, filename);
        }
        return this.sendFileAction(fullBasePath, filename, DELETE_FILE_ACTION);
    }

    @Override
    public String trashFileOnStorageServer(@Nonnull String fullBasePath, @Nonnull String filename) {
        return this.sendFileAction(fullBasePath, filename, TRASH_FILE_ACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private String sendFileAction(@Nonnull String fullBasePath, @Nonnull String filename, @Nonnull String action) {
        BufferedReader reader = null;
        try {
            ClientHttpPostRequest httpPost = new ClientHttpPostRequest(this.getStorageServerUploadService());
            httpPost.setParameter("action", action);
            httpPost.setParameter("filename", filename);
            httpPost.setParameter("basePath", fullBasePath);
            InputStream in = httpPost.post();
            reader = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
            String string = this.readAndConcatenateLines(reader);
            return string;
        }
        catch (IOException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error("Konnte Reader nicht schlie\u00dfen");
                }
            }
        }
    }

    private String getStorageServerUploadService() {
        return this._storageServerConfig.getStorageServerUrl() + "fileManagementServices";
    }

    private String readAndConcatenateLines(BufferedReader reader) throws IOException {
        String str;
        StringBuilder resultBuilder = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            resultBuilder.append(str).append("\n");
        }
        return resultBuilder.toString().trim();
    }
}

