/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.business.impl;

import com.freiheit.toro.common.business.TranslationManager;
import com.freiheit.toro.common.integration.persistence.TranslationDAO;
import com.freiheit.toro.common.shared.model.BeanWithEditableName;
import com.freiheit.toro.common.shared.model.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationManagerImpl
implements TranslationManager {
    private final TranslationDAO _translationDAO;

    @Autowired
    @ParametersAreNonnullByDefault
    public TranslationManagerImpl(TranslationDAO translationDAO) {
        this._translationDAO = translationDAO;
    }

    @Override
    public String getTranslation(String original, String languageCode) throws ServiceException {
        return this._translationDAO.getTranslation(original, languageCode);
    }

    @Override
    public <B extends BeanWithEditableName> Collection<B> translateCollection(Collection<B> coll, String languageCode) throws ServiceException {
        ArrayList<BeanWithEditableName> result = new ArrayList<BeanWithEditableName>(coll.size());
        for (BeanWithEditableName bean : coll) {
            BeanWithEditableName newBean = bean.cloneX();
            newBean.setName(this.getTranslation(bean.getName(), languageCode));
            result.add(newBean);
        }
        return result;
    }

    @Override
    public <B extends BeanWithEditableName> List<B> translateList(List<B> list, String languageCode) throws ServiceException {
        return (List)this.translateCollection(list, languageCode);
    }
}

