/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache.memcached;

import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.TrueFuture;
import com.freiheit.toro.cache.memcached.KeyScheduler;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.common.concurent.CollectedBooleanFuture;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MemcachedClientCacheImpl
implements MemcachedClientCache,
DisposableBean {
    static final int MAX_TIMESPAN = 2592000;
    static final int INTERNAL_ADDITIONAL_LIFETIME = 60;
    private static final Logger LOG = LoggerFactory.getLogger(MemcachedClientCacheImpl.class);
    private final KeyScheduler _keyScheduler = new KeyScheduler();
    private final MemcachedClient _client;
    private final int _timeoutMilliSeconds;

    @Autowired
    public MemcachedClientCacheImpl(@Value(value="${memcached.servers}") String servers, @Value(value="${memcached.timeoutMilliseconds:200}") int timeoutMilliSecnds) throws IOException {
        LOG.info("using memcached with timeout of " + timeoutMilliSecnds + " ms");
        System.setProperty("net.spy.log.LoggerImpl", "net.spy.log.Log4JLogger");
        this._timeoutMilliSeconds = timeoutMilliSecnds;
        this._client = new MemcachedClient((ConnectionFactory)new DefaultConnectionFactory(), AddrUtil.getAddresses((String)servers));
        this._client.setTranscoder((Transcoder)new ResultWrapperTranscoder((Transcoder<Object>)this._client.getTranscoder()));
    }

    @VisibleForTesting
    final MemcachedClient getClient() {
        return this._client;
    }

    private <T> T getInternal(String key) {
        LOG.debug("Getting key [{}]", (Object)key);
        Future f = this._client.asyncGet(key);
        try {
            Object rawResult = f.get();
            if (rawResult == null) {
                return null;
            }
            if (!(rawResult instanceof ResultWrapper)) {
                LOG.warn("Key [{}] did not contain a ResultWrapper-Object, removing it from cache and returning null", (Object)key);
                this._client.delete(key);
                return null;
            }
            ResultWrapper result = (ResultWrapper)rawResult;
            if (result.isExpired()) {
                LOG.debug("Key [{}] is stale, returning null", (Object)key);
                result.markStale();
                this.setInternal(key, result, 0L);
                return null;
            }
            Object cast = result.getValue();
            return cast;
        }
        catch (ExecutionException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("get for key [" + key + "] aborted", (Throwable)e);
            }
            return null;
        }
        catch (InterruptedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("get for key [" + key + "] interrupted", (Throwable)e);
            }
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @VisibleForTesting
    static String createKey(@Nonnull CacheKey cacheKey) {
        return MemcachedClientCacheImpl.createKey(cacheKey.getCacheName(), cacheKey.getKey());
    }

    @Nonnull
    private static String createKey(@Nonnull CacheName cacheName, @Nonnull String key) {
        return cacheName.getCacheName() + "#" + key;
    }

    @Nonnull
    private static ImmutableSet<String> createKeys(@Nonnull CacheName cacheName, @Nonnull Iterable<String> keys) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (String key : keys) {
            resultBuilder.add((Object)MemcachedClientCacheImpl.createKey(cacheName, key));
        }
        return resultBuilder.build();
    }

    @Override
    public <T> T get(CacheName cacheName, String key2) throws ClassCastException {
        final String key = MemcachedClientCacheImpl.createKey(cacheName, key2);
        Callable performGet = new Callable<T>(){

            @Override
            public T call() throws ClassCastException {
                return MemcachedClientCacheImpl.this.getInternal(key);
            }
        };
        try {
            return MemcachedClientCacheImpl.getWithTimeout(this._keyScheduler.addTask(key, performGet), this._timeoutMilliSeconds);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (TimeoutException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Get for key [" + key + "] timed out after " + this._timeoutMilliSeconds);
            }
            return null;
        }
        catch (ExecutionException e) {
            LOG.error("Task threw exception", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> Map<String, T> getBulk(CacheName cacheName, Collection<String> keys) {
        Future future = this._client.asyncGetBulk(MemcachedClientCacheImpl.createKeys(cacheName, keys));
        try {
            HashMap resultMap = Maps.newHashMap();
            Map results = (Map)MemcachedClientCacheImpl.getWithTimeout(future, this._timeoutMilliSeconds);
            for (String key : keys) {
                ResultWrapper result = (ResultWrapper)results.get(MemcachedClientCacheImpl.createKey(cacheName, key));
                if (result == null) continue;
                if (result.isExpired()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Key [" + key + "] is stale, removing from map");
                    }
                    result.markStale();
                    this.setInternal(MemcachedClientCacheImpl.createKey(cacheName, key), result, 0L);
                    continue;
                }
                resultMap.put(key, result.getValue());
            }
            return resultMap;
        }
        catch (TimeoutException e) {
            LOG.warn("getBulk timed out after " + this._timeoutMilliSeconds, (Throwable)e);
            return ImmutableMap.of();
        }
        catch (ExecutionException e) {
            LOG.warn("getBulk aborted", (Throwable)e);
            return ImmutableMap.of();
        }
        catch (InterruptedException e) {
            LOG.warn("getBuild interrupted", (Throwable)e);
            return ImmutableMap.of();
        }
    }

    @Override
    public Future<Boolean> add(CacheName cacheName, String key2, Object o, final long expires) {
        if (o == null) {
            return TrueFuture.INSTANCE;
        }
        final String key = MemcachedClientCacheImpl.createKey(cacheName, key2);
        LOG.debug("Adding key [{}]", (Object)key);
        final CachedData cachedData = this._client.getTranscoder().encode(new ResultWrapper<Object>(expires + System.currentTimeMillis() / 1000L, o));
        Callable<Boolean> tryToAdd = new Callable<Boolean>(){

            @Override
            public Boolean call() throws ExecutionException, InterruptedException {
                Boolean result = (Boolean)MemcachedClientCacheImpl.this._client.add(key, MemcachedClientCacheImpl.this.calcLifetime(expires), (Object)cachedData).get();
                if (!result.booleanValue()) {
                    LOG.debug("Key [{}] couldn't be added, looking if it is a stale one", (Object)key);
                    Object cached = MemcachedClientCacheImpl.this._client.get(key);
                    if (cached instanceof ResultWrapper) {
                        ResultWrapper wrapped = (ResultWrapper)cached;
                        if (wrapped.isStale() || wrapped.isExpired()) {
                            LOG.debug("Key [{}] is stale, replacing with new value", (Object)key);
                            return (Boolean)MemcachedClientCacheImpl.this._client.set(key, MemcachedClientCacheImpl.this.calcLifetime(expires), (Object)cachedData).get();
                        }
                        LOG.debug("Key [{}] isn't stale, doing nothing", (Object)key);
                    } else {
                        LOG.warn("Key [{}] holds unknown object, will overwrite!", (Object)key);
                        return (Boolean)MemcachedClientCacheImpl.this._client.set(key, MemcachedClientCacheImpl.this.calcLifetime(expires), (Object)cachedData).get();
                    }
                }
                return result;
            }
        };
        return this._keyScheduler.addTask(key, tryToAdd);
    }

    @Override
    public Future<Boolean> add(CacheName cacheName, String key, Object o) {
        return this.add(cacheName, key, o, DEFAULT_LIFETIME);
    }

    @Override
    public Future<Boolean> set(CacheName cacheName, String key, Object o, long expires) {
        return this.setInternal(MemcachedClientCacheImpl.createKey(cacheName, key), new ResultWrapper<Object>(expires + System.currentTimeMillis() / 1000L, o), expires);
    }

    @Override
    public Future<Boolean> set(CacheName cacheName, String key, Object o) {
        return this.set(cacheName, key, o, DEFAULT_LIFETIME);
    }

    private Future<Boolean> setInternal(final String key, final Object object, final long expires) {
        Callable<Boolean> performSet = new Callable<Boolean>(){

            @Override
            public Boolean call() throws InterruptedException, ExecutionException {
                LOG.debug("Setting (updating) key [{}]", (Object)key);
                return (Boolean)MemcachedClientCacheImpl.this._client.set(key, MemcachedClientCacheImpl.this.calcLifetime(expires), object).get();
            }
        };
        return this._keyScheduler.addTask(key, performSet);
    }

    @Override
    public Future<Boolean> delete(CacheName cacheName, String key2) {
        final String key = MemcachedClientCacheImpl.createKey(cacheName, key2);
        Callable<Boolean> performDelete = new Callable<Boolean>(){

            @Override
            public Boolean call() throws InterruptedException, ExecutionException {
                return (Boolean)MemcachedClientCacheImpl.this._client.delete(key).get();
            }
        };
        return this._keyScheduler.addTask(key, performDelete);
    }

    @Override
    public Future<Boolean> deleteKeys(CacheName cacheName, Iterable<String> keys) {
        ImmutableList.Builder futuresBuilder = ImmutableList.builder();
        for (String key : keys) {
            futuresBuilder.add(this.delete(cacheName, key));
        }
        return new CollectedBooleanFuture((Iterable<? extends Future<? extends Boolean>>)futuresBuilder.build());
    }

    @Override
    public Future<Boolean> flush() {
        this._keyScheduler.stopAllTasks();
        return this._client.flush();
    }

    int calcLifetime(long expires) {
        if (expires <= 2592000L) {
            if (expires + 60L <= 2592000L) {
                return (int)expires + 60;
            }
            long time = System.currentTimeMillis() / 1000L;
            return (int)time + (int)expires + 60;
        }
        long value = Math.max(expires + 60L, expires);
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    @Override
    public void testCache() throws InterruptedException, ExecutionException, TimeoutException {
        MemcachedClientCacheImpl.getWithTimeout(this._client.asyncGet("ping"), this._timeoutMilliSeconds);
    }

    private static <T> T getWithTimeout(Future<T> future, int timeoutMilliSeconds) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(timeoutMilliSeconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> T get(CacheKey cacheKey) {
        return this.get(cacheKey.getCacheName(), cacheKey.getKey());
    }

    @Override
    public Future<Boolean> add(CacheKey cacheKey, Object value) {
        return this.add(cacheKey.getCacheName(), cacheKey.getKey(), value);
    }

    @Override
    public Future<Boolean> delete(CacheKey cacheKey) {
        return this.delete(cacheKey.getCacheName(), cacheKey.getKey());
    }

    @Override
    public Future<Boolean> add(CacheKey cacheKey, Object value, long expires) {
        return this.add(cacheKey.getCacheName(), cacheKey.getKey(), value, expires);
    }

    @Override
    public Future<Boolean> set(CacheKey cacheKey, Object value) {
        return this.set(cacheKey.getCacheName(), cacheKey.getKey(), value);
    }

    @Override
    public <T> Map<CacheKey, T> getBulk(Iterable<? extends CacheKey> keys) {
        ImmutableSet.Builder stringKeys = ImmutableSet.builder();
        CacheName cacheName = null;
        for (CacheKey cacheKey : keys) {
            stringKeys.add((Object)cacheKey.getKey());
            if (cacheName == null) {
                cacheName = cacheKey.getCacheName();
                continue;
            }
            if (cacheName.equals(cacheKey.getCacheName())) continue;
            throw new IllegalStateException();
        }
        HashMap result = Maps.newHashMap();
        Map<String, T> map = this.getBulk(cacheName, (Collection<String>)stringKeys.build());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            result.put(new CacheKey(cacheName, entry.getKey()), entry.getValue());
        }
        return result;
    }

    @Override
    public Future<Boolean> set(CacheKey cacheKey, Object value, long expires) {
        return this.set(cacheKey.getCacheName(), cacheKey.getKey(), value, expires);
    }

    @Override
    public void deleteAll(CacheName cacheName) {
        throw new UnsupportedOperationException("Memcached is unable to delete all keys starting with a prefix");
    }

    @Override
    public boolean isDeleteAllByCacheNameAllowed() {
        return false;
    }

    public void destroy() {
        this._client.shutdown();
        this._keyScheduler.shutdown();
    }

    static final class ResultWrapperTranscoder
    implements Transcoder<Object> {
        private static final int RESULT_WRAPPER_FLAG = 32768;
        private final Transcoder<Object> _realTranscoder;

        public ResultWrapperTranscoder(Transcoder<Object> realTrancoder) {
            this._realTranscoder = realTrancoder;
        }

        protected static long decodeLong(byte[] arr) {
            long result = 0L;
            for (int i = 7; i >= 0; --i) {
                result <<= 8;
                byte a = arr[i];
                result |= a >= 0 ? (long)a : (long)(256 + a);
            }
            return result;
        }

        protected static byte[] encodeLong(long l) {
            long l1 = l;
            byte[] arr = new byte[8];
            for (int i = 0; i < 8; ++i) {
                arr[i] = (byte)(l1 & 0xFFL);
                l1 >>= 8;
            }
            return arr;
        }

        public Object decode(CachedData cacheddata) {
            int flags = cacheddata.getFlags();
            if ((flags & 0x8000) == 0) {
                return this._realTranscoder.decode(cacheddata);
            }
            flags &= 0xFFFF7FFF;
            byte[] data = cacheddata.getData();
            int realDataLength = data.length - 9;
            byte[] realData = new byte[realDataLength];
            byte[] lifetimeData = new byte[8];
            byte[] staleData = new byte[1];
            System.arraycopy(data, 0, lifetimeData, 0, 8);
            System.arraycopy(data, 8, staleData, 0, 1);
            System.arraycopy(data, 9, realData, 0, realDataLength);
            Object object = this._realTranscoder.decode(new CachedData(flags, realData));
            ResultWrapper<Object> wrapper = new ResultWrapper<Object>(ResultWrapperTranscoder.decodeLong(lifetimeData), object);
            wrapper.setStale(staleData[0] == 49);
            return wrapper;
        }

        public CachedData encode(Object obj) {
            if (obj instanceof CachedData) {
                return (CachedData)obj;
            }
            if (obj instanceof ResultWrapper) {
                ResultWrapper wrapped = (ResultWrapper)obj;
                CachedData encoded = this._realTranscoder.encode(wrapped.getValue());
                byte[] realData = encoded.getData();
                int newLength = realData.length + 9;
                byte[] data = new byte[newLength];
                byte[] lifetimeData = ResultWrapperTranscoder.encodeLong(wrapped.getLifetime());
                byte[] staleData = new byte[]{wrapped.isStale() ? (byte)49 : 48};
                System.arraycopy(lifetimeData, 0, data, 0, 8);
                System.arraycopy(staleData, 0, data, 8, 1);
                System.arraycopy(realData, 0, data, 9, realData.length);
                return new CachedData(encoded.getFlags() | 0x8000, data);
            }
            return this._realTranscoder.encode(obj);
        }
    }

    private static final class ResultWrapper<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long _lifetime;
        private boolean _stale = false;
        private final T _value;

        public ResultWrapper(long expires, T value) {
            this._lifetime = expires;
            this._value = value;
        }

        public final T getValue() {
            return this._value;
        }

        public final void markStale() {
            if (!this._stale) {
                this._lifetime += 60L;
                this._stale = true;
            }
        }

        public boolean isExpired() {
            return this._lifetime < System.currentTimeMillis() / 1000L;
        }

        public boolean isStale() {
            return this._stale;
        }

        public long getLifetime() {
            return this._lifetime;
        }

        public void setStale(boolean stale) {
            this._stale = stale;
        }
    }
}

