/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache.ehcache.impl;

import com.freiheit.toro.cache.ehcache.EhCacheHeartbeatService;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.cache.ehcache.EhcacheClientConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.toolbox.concurrent.RepeatingThread;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.curator.shaded.com.google.common.base.Strings;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EhCacheHeartbeatServiceImpl
implements EhCacheHeartbeatService {
    private static final Logger LOG = LoggerFactory.getLogger(EhCacheHeartbeatServiceImpl.class);
    private final EhcacheClientConfiguration _configuration;
    private final EhcacheClient _client;
    private final AbstractSingleLoadingCacheAccessor<?, String, DateTime> _heartbeatCache;
    private volatile RepeatingThread _thread;
    private volatile boolean _isCurrentlyAlive = true;

    @Autowired
    public EhCacheHeartbeatServiceImpl(EhcacheClient client, EhcacheClientConfiguration configuration) {
        this._client = client;
        this._configuration = configuration;
        this._heartbeatCache = AbstractSingleLoadingCacheAccessor.create(this._client, EhCacheHeartbeatCache.HEART_BEAT, i -> new DateTime(), Function.identity());
    }

    @PostConstruct
    public void init() {
        this._thread = new RepeatingThread(this.getClass().getSimpleName(), this::run);
    }

    @PreDestroy
    public void destroy() {
        if (this._thread != null) {
            this._thread.cancel();
        }
    }

    private void run() {
        try {
            this._heartbeatCache.invalidateKey(this.getLocalCacheKey());
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            this.isAlive();
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isAlive() {
        ImmutableSet peers = ImmutableSet.builder().addAll(this._configuration.getPeers()).add((Object)this.getLocalCacheKey()).build();
        ImmutableMap<String, DateTime> lastCacheMisses = this._heartbeatCache.getMap((Set<String>)peers);
        DateTime now = new DateTime();
        boolean logErrors = this._isCurrentlyAlive;
        boolean alive = true;
        for (String peer : peers) {
            DateTime lastCacheMiss = (DateTime)Preconditions.checkNotNull((Object)((DateTime)lastCacheMisses.get((Object)peer)));
            if (lastCacheMiss.isAfter((ReadableInstant)now)) {
                if (logErrors) {
                    LOG.error("host {}: the last cache miss ({}) is the future (now {}), this should not happen", new Object[]{peer, lastCacheMiss, now});
                }
                alive = false;
                continue;
            }
            if (!new Duration((ReadableInstant)lastCacheMiss, (ReadableInstant)now).isLongerThan((ReadableDuration)Duration.standardSeconds((long)30L))) continue;
            if (logErrors) {
                LOG.error("host {}: the last cache miss ({}) is too old (now {})", new Object[]{peer, lastCacheMiss, now});
            }
            alive = false;
        }
        if (alive && !logErrors) {
            LOG.info("recovered from error state");
        }
        this._isCurrentlyAlive = alive;
        return alive;
    }

    private String getLocalCacheKey() {
        Integer port = this._configuration.getPort();
        String host = Strings.nullToEmpty((String)this._configuration.getHost());
        return port != null ? host + ":" + port : host;
    }

    public static enum EhCacheHeartbeatCache implements EhCacheName
    {
        HEART_BEAT;


        @Override
        public String getCacheName() {
            return this.name();
        }

        @Override
        public long getTimeToLiveSeconds() {
            return TimeUnit.DAYS.toSeconds(3653L);
        }

        @Override
        public int getPassThroughLimit() {
            return Integer.MAX_VALUE;
        }
    }
}

