/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache.ehcache;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClientConfiguration;
import com.freiheit.toro.cache.ehcache.impl.EhCacheHeartbeatServiceImpl;
import com.freiheit.toro.common.business.impl.LanguageServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.business.impl.AlbumServiceImpl;
import de.justsoftware.onx.appswitcher.business.impl.AppConfigServiceImpl;
import de.justsoftware.onx.calendar.business.impl.CalendarFeedReadWriteDataServiceImpl;
import de.justsoftware.onx.common.business.impl.HostPropertiesReadDataServiceImpl;
import de.justsoftware.onx.container.business.EntityMemberServiceEhCacheName;
import de.justsoftware.onx.container.business.impl.EntityMemberReadWriteDataServiceImpl;
import de.justsoftware.onx.container.business.impl.EntityStatusReadWriteDataServiceImpl;
import de.justsoftware.onx.container.business.impl.EntityTypeAppMappingServiceImpl;
import de.justsoftware.onx.container.business.impl.EntityVersionReadWriteDataServiceImpl;
import de.justsoftware.onx.design.business.impl.ThemeReadWriteDataServiceImpl;
import de.justsoftware.onx.integration.business.impl.PersonExternalIdReadWriteDataServiceImpl;
import de.justsoftware.onx.like.business.impl.LikeReadWriteDataServiceImpl;
import de.justsoftware.onx.person.business.FriendServiceCacheName;
import de.justsoftware.onx.person.business.impl.PersonServiceEhCacheName;
import de.justsoftware.onx.profile.business.impl.ProfileReadWriteDataServiceImpl;
import de.justsoftware.onx.security.oauth.business.impl.OAuthClientReadWriteDataServiceImpl;
import de.justsoftware.onx.security.oauth.business.impl.OAuthTokenReadWriteDataServiceImpl;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.workstream.business.impl.WorkstreamDataServiceImpl;
import de.justsoftware.onx.workstream.business.impl.WorkstreamReadDataServiceImpl;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EhcacheClientConfigurationImpl
implements EhcacheClientConfiguration {
    private final Integer _port;
    private final ImmutableSet<String> _peers;
    private final ImmutableSet<EhCacheName> _cacheNames;
    private final String _host;
    private static final ImmutableSet<Class<? extends EhCacheName>> ehcaches;

    @Autowired
    public EhcacheClientConfigurationImpl(@Nullable @Value(value="${ehcache.rmi.host}") String host, @Nullable @Value(value="${ehcache.rmi.port}") String port, @Nonnull @Value(value="${ehcache.rmi.peers}") String peers) {
        this(host, EhcacheClientConfigurationImpl.parsePort(port), peers, (Iterable<? extends Class<? extends EhCacheName>>)ehcaches);
    }

    @VisibleForTesting
    EhcacheClientConfigurationImpl(@Nullable String host, @Nullable Integer port, String peers, Iterable<? extends Class<? extends EhCacheName>> cacheClasses) {
        this(host, port, EhcacheClientConfigurationImpl.extractPeers(peers), cacheClasses);
    }

    @VisibleForTesting
    EhcacheClientConfigurationImpl(@Nullable String host, @Nullable Integer port, @Nonnull Iterable<String> peers, Iterable<? extends Class<? extends EhCacheName>> cacheClasses) {
        this._port = port;
        this._peers = ImmutableSet.copyOf(peers);
        this._cacheNames = EhcacheClientConfigurationImpl.build(cacheClasses);
        this._host = StringUtils.trimToNull((String)host);
    }

    @CheckForNull
    private static Integer parsePort(@Nullable String port) {
        if (StringUtils.isBlank((String)port)) {
            return null;
        }
        return Integer.valueOf(port);
    }

    private static Iterable<String> extractPeers(String peers) {
        return Splitter.on((char)',').omitEmptyStrings().split((CharSequence)peers);
    }

    @Nonnull
    private static ImmutableSet<EhCacheName> build(Iterable<? extends Class<? extends EhCacheName>> cacheClasses) {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (Class<? extends EhCacheName> clazz : cacheClasses) {
            resultBuilder.add((Object[])clazz.getEnumConstants());
        }
        return resultBuilder.build();
    }

    @Override
    public Integer getPort() {
        return this._port;
    }

    public ImmutableSet<String> getPeers() {
        return this._peers;
    }

    @Override
    public Iterable<? extends EhCacheName> getCacheNames() {
        return this._cacheNames;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    static {
        ImmutableSet.Builder objectBuilder = ImmutableSet.builderWithExpectedSize((int)23);
        ehcaches = objectBuilder.add((Object[])new Class[]{PersonServiceEhCacheName.class, FriendServiceCacheName.class, EntityMemberServiceEhCacheName.class, PersonExternalIdReadWriteDataServiceImpl.PersonExternalIdServiceEhCacheName.class, EntityMemberReadWriteDataServiceImpl.EntityMemberEhCacheName.class, EntityTypeAppMappingServiceImpl.EntityTypeAppMappingEhcacheName.class, AlbumServiceImpl.AlbumServiceCacheName.class, LanguageServiceImpl.LanguageServiceCacheName.class, EntityStatusReadWriteDataServiceImpl.EntityStatusEhCacheName.class, EntityVersionReadWriteDataServiceImpl.EntityVersionEhCacheName.class, ThemeReadWriteDataServiceImpl.ThemeEhCacheNames.class, WorkstreamDataServiceImpl.WorkstreamEhcacheName.class, WorkstreamReadDataServiceImpl.WorkstreamReadEhcacheName.class, OAuthClientReadWriteDataServiceImpl.OAuthClientEhCacheName.class, OAuthTokenReadWriteDataServiceImpl.OAuthTokenEhCacheName.class, LikeReadWriteDataServiceImpl.LikeServiceEhCacheName.class, CalendarFeedReadWriteDataServiceImpl.CalendarFeedServiceEhCacheName.class, ProfileReadWriteDataServiceImpl.ProfileServiceEhCacheName.class, HostPropertiesReadDataServiceImpl.HostPropertiesEhCacheName.class, EhCacheHeartbeatServiceImpl.EhCacheHeartbeatCache.class, AppConfigServiceImpl.AppConfigCacheName.class, UserGroupService.UserGroupEhCacheName.class}).build();
    }
}

