/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache;

import com.freiheit.toro.cache.CacheName;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public interface CacheClient<C extends CacheName> {
    public static final long SHORT_LIFETIME = TimeUnit.MINUTES.toSeconds(5L);
    public static final long LONG_LIFETIME = TimeUnit.DAYS.toSeconds(1L);
    public static final long TIL_END_OF_UNIX_TIME = Integer.MAX_VALUE;
    public static final long DEFAULT_LIFETIME = TimeUnit.HOURS.toSeconds(6L);
    public static final int DEFAULT_MAX_ELEMENTS = 200;
    public static final Serializable NULL = NullValue.INSTANCE;

    public <T> T get(@Nonnull C var1, String var2) throws ClassCastException;

    @Nonnull
    public <T> Map<String, T> getBulk(@Nonnull C var1, Collection<String> var2) throws ClassCastException;

    @Nonnull
    public Future<Boolean> add(@Nonnull C var1, String var2, Object var3);

    @Nonnull
    public Future<Boolean> delete(@Nonnull C var1, String var2);

    @Nonnull
    public Future<Boolean> deleteKeys(@Nonnull C var1, Iterable<String> var2);

    public void deleteAll(@Nonnull C var1);

    public boolean isDeleteAllByCacheNameAllowed();

    @Nonnull
    public Future<Boolean> flush();

    public static enum NullValue {
        INSTANCE;

    }
}

