/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.admin.shared.server.superoperty;

import com.freiheit.superoperty.Property;
import com.freiheit.superoperty.SuperopertyContainer;
import com.freiheit.superoperty.container.CollectionConverter;
import com.freiheit.superoperty.container.DateTimeConverter;
import com.freiheit.superoperty.container.EnumConverter;
import com.freiheit.superoperty.container.FilterTypeCollectionConverter;
import com.freiheit.superoperty.container.MenulinksConverter;
import com.freiheit.superoperty.converter.BooleanConverter;
import com.freiheit.superoperty.converter.ListConverter;
import com.freiheit.superoperty.converter.LongConverter;
import com.freiheit.superoperty.converter.RegexpCheckConverter;
import com.freiheit.superoperty.converter.SimpleStringConverter;
import com.freiheit.superoperty.event.SuperopertyChangeListener;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.admin.shared.server.superoperty.TimeZoneListProvider;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.business.superoperty.PeriodConverter;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.server.util.RegExUtilServer;
import de.justsoftware.onx.container.server.shared.model.EntityPreviewAmount;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.menu.server.model.CustomMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MenuLinkDefinition;
import de.justsoftware.onx.menu.shared.model.ExpandStatus;
import de.justsoftware.onx.menu.shared.model.MenuLinkLevel;
import de.justsoftware.onx.person.business.ShowBirthdayOption;
import de.justsoftware.onx.person.shared.model.ProductHintsOption;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankToggleValue;
import de.justsoftware.onx.workstream.shared.model.WorkstreamReadConfig;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;

public class SuperopertySettings
implements Settings {
    private static final String PATH_STARTPAGE = "Settings/Startpage";
    private static final String PATH_LOGIN = "Settings/login";
    private static final String PATH_SEARCH = "Settings/Search";
    private static final String PATH_MENU = "Settings/Menu";
    private static final String PATH_EMAIL_PATTERN = "Settings/EmailPattern";
    private static final String PATH_REGISTRATION = "Settings/Registration";
    private static final String PATH_WORKSTREAM = "Settings/Workstream";
    private static final String PATH_HORIZONTAL_NAVIGATION = "Settings/Horizontal Navigation";
    private static final String PATH_BREADCRUMB = "Settings/Breadcrumb";
    private static final String PATH_PROFILE = "Settings/profile";
    private static final String PATH_CHAT = "Settings/Chat";
    private static final String PATH_WIKI = "Settings/Wiki";
    private static final String PATH_SUBSCRIPTIONS = "Settings/subscriptions";
    private static final String PATH_MOBILE = "Settings/mobile";
    private static final String PATH_RECOMMENDATION = "Settings/Recommendation";
    private static final String PATH_APP = "Settings/App";
    private static final String PATH_DRIVE = "Settings/Drive";
    private static final String PATH_REST = "Settings/rest";
    private static final String PATH_ICONS = "Settings/Icons";
    private static final String PATH_DATA_RETENTION = "Settings/Data Retention";
    private static final String PATH_FEATURE_TOGGLE = "Settings/Feature Toggle";
    private static final String PATH_MAIL = "Settings/Mail";
    private static final String PATH_PIWIK = "Settings/Piwik";
    private static final String PATH_INVITATION = "Settings/Invitation";
    private static final String PATH_NOTIFICATION = "Settings/Notification";
    private static final String PATH_NEWS = "Settings/News";
    private static final int IMAGE_ICON_SMALL_SIZE_X = 16;
    private static final int IMAGE_ICON_SMALL_SIZE_Y = 16;
    private final Property _workstreamAggregateTimeLimit;
    private final Property _clientPollingInterval;
    private final Property _smtpServer;
    private final Property _smtpUsername;
    private final Property _smtpPassword;
    private final Property _smtpSender;
    private final Property _enableTls;
    private final Property _listUnsubscribeUrls;
    private final Property _smtpPort;
    private final Property _defaultTimeZone;
    private final Property _isProfileImageLegalAgreementRequired;
    private final Property _searchIndexFetchSize;
    private final Property _searchIndexQueueMaxminutesInProcess;
    private final Property _learnToRankEnabled;
    private final Property _learnToRankReRankDocCount;
    private final Property _indexPath;
    private final Property _searchSuggestQueryFields;
    private final Property _myContentTeaserCount;
    private final Property _pageMenuLinks;
    private final Property _showIcons;
    private final Property _mobileTrackingEnabled;
    private final Property _registerEmailPattern;
    private final Property _emailBlacklist;
    private final Property _inviteEmailMaxMessageLength;
    private final Property _defaultSiteTitle;
    private final Property _systemMinDateYear;
    private final Property _systemMaxDateYear;
    private final Property _importPersonsEnabled;
    private final Property _importUserGroupsEnabled;
    private final Property _importQueueCronJobExpression;
    private final Property _failedImportResultRecipient;
    private final Property _importPassiveSubscriptionDefaultEntityIds;
    private final Property _importRecommendedSubscriptionDefaultEntityIds;
    private final Property _importMembershipDefaultEntityIds;
    private final Property _importDefaultStaticRoles;
    private final Property _migrationLdapExportCronJobExpression;
    private final Property _migrationBatchSize;
    private final Property _termsAcceptanceRequired;
    private final Property _additionalTermsAcceptanceRequired;
    private final Property _activationViaOptInEnabled;
    private final Property _defaultEntityId;
    private final Property _registrationAutoJoinEntityIds;
    private final Property _activeFilterTypes;
    private final Property _collapseToRestrictingFilters;
    private final Property _alwaysShowSearchContextFilter;
    private final Property _googleAnalyticsAccount;
    private final Property _registrationAutoJoinForParentEntitiesEnabled;
    private final Property _isClientLoggingEnable;
    private final Property _defaultLanguage;
    private final Property _favIcon;
    private final Property _showProductHints;
    private final Property _searchContextShown;
    private final Property _showFooterPageTermsInSameWindow;
    private final Property _showFooterPageDataProtectionInSameWindow;
    private final Property _showFooterPageHelpInSameWindow;
    private final Property _showFooterPageImprintInSameWindow;
    private final Property _showFooterPagePressInSameWindow;
    private final Property _showFooterPageAboutInSametWindow;
    private final Property _showFooterPageArticleOfAssociationInSameWindow;
    private final Property _displayEntityTypeInBreadCrumbs;
    private final Property _modificationRestrictedPersonFields;
    private final Property _hiddenPersonFields;
    private final Property _isPasswordResetEnabled;
    private final Property _adfsEnabled;
    private final Property _defaultPowerBarOption;
    private final Property _newChatMessagesEmailSenderCronExpr;
    private final Property _cleanupChatsAfter;
    private final Property _cleanupWikiAfter;
    private final Property _ordinaryUsersMayInviteMembers;
    private final Property _ordinaryUsersMayRecommendToMembers;
    private final Property _personIdForAdminTransfer;
    private final Property _mailReceivingRolesWhenProfileBlockedList;
    private final Property _inheritedSubscriptionForMembersOnJoin;
    private final Property _inheritedSubscriptionForAdminsOnJoin;
    private final Property _inheritedSubscriptionForMembersOnEntityUpdate;
    private final Property _inheritedSubscriptionForAdminsOnEntityUpdate;
    private final Property _showBirthdaysOnStartPage;
    private final Property _csvExportColumns;
    private final Property _registerPersonFields;
    private final Property _blockUserAfterRegistration;
    private final Property _appFilesPort;
    private final Property _appFilesBasePath;
    private final Property _workstreamReadPollingConfig;
    private final Property _workstreamReadMinDate;
    private final Property _workstreamReadPollRatio;
    private final Property _dataRetentionMinimumTime;
    private final Property _dataRetentionDeleteTaskCronExpr;
    private final Property _entityPreviewAmount;
    private final Property _sendPasswordResetCodeMailAfterRegistration;
    private final Property _drivePublicLinksEnabled;
    private final Property _driveDocumentMigrationDate;
    private final Property _driveUploadMaxFileSize;
    private final Property _driveUploadAllowedMimeTypes;
    private final Property _historyCompactorCron;
    private final Property _piwikUrl;
    private final Property _piwikSiteId;
    private final Property _piwikTokenAuth;
    private final Property _deviceLockRequired;
    private final Property _mobileSupportedLegacyEntityTypes;
    private final Property _entityTypesToAddUsersAsMembersOnRecommendationTask;
    private final Property _notificationMailCron;
    private final Property _browserPushServiceEnabled;
    private final Property _isAccountLockEnabled;
    private final Property _isQuickPollsEnabled;
    private final Property _isAdaSSOConfigEnabled;
    private final Property _isUserImpersonationEnabled;
    private final Property _driveDeletionDelay;
    private final Property _newsDeletionDelay;

    public SuperopertySettings(SuperopertyContainer container) {
        this._workstreamReadPollingConfig = container.defineFinalProperty("Settings/Workstream/Workstream read polling config", EnumConverter.class, WorkstreamReadConfig.class.getName(), "Configure if clients shall actively poll for unread workstream entries, mark entities as unread in the UI only or if it is completely disabled. Consider setting \"Workstream read min date\" to current date, when enabling this from complete disabled state.", WorkstreamReadConfig.ENABLED.name());
        this._workstreamReadPollRatio = container.defineFinalProperty("Settings/Workstream/Workstream read poll ratio", LongConverter.class, null, "This ratio defines how many poll events are needed for a workstream read poll.", "1");
        this._workstreamReadMinDate = container.defineFinalProperty("Settings/Workstream/Workstream read min date", DateTimeConverter.class, null, "This is the lower bound for workstream messages which are shown as unread. Change this value to current date, if you turn polling on or if you want to test.", new DateTimeConverter().convertFromObject(new DateTime()));
        this._workstreamAggregateTimeLimit = container.defineFinalProperty("Settings/Workstream/Workstream aggregate time limit", PeriodConverter.class, null, "Do not aggregate workstream messages when more than the specified period has passed between creation of the two message.", "12h");
        this._clientPollingInterval = container.defineFinalProperty("Settings/Client polling interval", LongConverter.class, null, "The interval for polling from the client (in seconds). An interval of 0 deactivates the polling completely.", "60");
        this._smtpServer = container.defineFinalProperty("Settings/SMTP Server", SimpleStringConverter.class, null, "The SMTP server to be used for sending mail", "127.0.0.1");
        this._smtpPort = container.defineFinalProperty("Settings/SMTP Port", LongConverter.class, null, "The SMTP PORT to be used for sending mail", "25");
        this._smtpUsername = container.defineFinalProperty("Settings/SMTP Username", SimpleStringConverter.class, null, "The username for the SMTP server. Leave empty for no authorization", "");
        this._smtpPassword = container.defineFinalProperty("Settings/SMTP Password", SimpleStringConverter.class, null, "The password for the SMTP server", "");
        this._smtpSender = container.defineFinalProperty("Settings/SMTP Sender", SimpleStringConverter.class, null, "The email address that appears in the \"From\" field", "Just Social <no-reply@justsoftwareag.com>");
        this._enableTls = container.defineFinalProperty("Settings/enableTls", BooleanConverter.class, null, "enableTls", "false");
        this._listUnsubscribeUrls = container.defineFinalProperty("Settings/Mail/listUnsubscibeHeader", CollectionConverter.class, null, "This List of URLs is appended to the E-Mail header to help bypassing spam filters. You can add multple URLs here, or make it empty.", "https://support.just.social/hc/de/articles/115003298865");
        this._isProfileImageLegalAgreementRequired = container.defineFinalProperty("Settings/enableProfileImageLegalAgreement", BooleanConverter.class, null, "enableProfileImageLegalAgreement", "false");
        this._searchIndexFetchSize = container.defineFinalProperty("Settings/Search/max indexing fetch size", LongConverter.class, null, "Max fetch size of entries used during indexing solr", "1000");
        this._searchIndexQueueMaxminutesInProcess = container.defineFinalProperty("Settings/Search/max minutes in process", LongConverter.class, null, "Max time in minutes an item should be in process before the search indexer will retry to index this item", "60");
        this._learnToRankEnabled = container.defineFinalProperty("Settings/Search/learn to rank enabled", EnumConverter.class, LearnToRankToggleValue.class.getName(), "Enable the learn to rank search feature. If enabled, user identifiable search tracking is also enabled.", LearnToRankToggleValue.ENABLED.name());
        this._learnToRankReRankDocCount = container.defineFinalProperty("Settings/Search/learn to rank re-rank document count", LongConverter.class, null, "Define the count of the top documents we want to re-rank during applying learn to rank.", "1000");
        this._indexPath = container.defineFinalProperty("Settings/Search/index path", BooleanConverter.class, null, "Enable the ability to search in the path (taxonomy) of elements. Activating this feature may severely impact performance (aka deadly sin)!", "false");
        this._searchSuggestQueryFields = container.defineFinalProperty("Settings/Search/suggest query fields", SimpleStringConverter.class, null, "Defines the qf-Parameter of the solr search that is executed for typeahead searches in JUST. Only change this value, if you know what you are doing.", "name name_substring");
        this._pageMenuLinks = container.defineFinalProperty("Settings/Menu/menu links", MenulinksConverter.class, null, "A list of links which are shown in the upper part of the left navigation of the Page/News app.", MenulinksConverter.convertFromObject((Collection<? extends MenuLinkDefinition>)ImmutableList.of((Object)new CustomMenuLinkDefinition(new MenuLinkLevel(0, ExpandStatus.ALWAYS_EXPANDED), (ImmutableSet<String>)ImmutableSet.of((Object)"LOGGED_IN"), IconType.LINK, "#/people/users", (ImmutableMap<String, String>)ImmutableMap.of((Object)"de", (Object)"Nutzer", (Object)"en", (Object)"Users")), (Object)new CustomMenuLinkDefinition(new MenuLinkLevel(0, ExpandStatus.ALWAYS_EXPANDED), (ImmutableSet<String>)ImmutableSet.of((Object)"LOGGED_IN"), IconType.LINK, "#/people/groups", (ImmutableMap<String, String>)ImmutableMap.of((Object)"de", (Object)"Gruppen", (Object)"en", (Object)"Groups")))));
        this._showIcons = container.defineFinalProperty("Settings/Icons/show icons", BooleanConverter.class, null, "Should Juco display first level menu icons and icons for the origin type in microblog header?", "false");
        this._mobileTrackingEnabled = container.defineFinalProperty("Settings/mobile/tracking enabled", BooleanConverter.class, null, "Toggle to en-/disable tracking in the mobile web page or app.", "false");
        this._defaultTimeZone = container.defineFinalProperty("Settings/Default Timezone", ListConverter.class, TimeZoneListProvider.class.getName(), "defines the default timezone of the platform", TimeZone.GERMANY.name());
        this._registerEmailPattern = container.defineFinalProperty("Settings/EmailPattern/register email pattern", SimpleStringConverter.class, null, "defines which email addresses are allowed to sign up. Use '*' and '?' as wildcards and ' ', ',' or ';'\nto separate emails. e.g. '*@justsoftware.de' or '*@*google.com, *@yahoo.com, bill.gates@microsoft.com'.\nUse '*' to allow every email or '' to allow no email.", "*");
        this._emailBlacklist = container.defineFinalProperty("Settings/EmailPattern/invite email blacklist", SimpleStringConverter.class, null, "defines which email addresses are filtered out when sending external invites. Use '*' and '?' as wildcards and ' ', ',' or ';'\nto separate emails. e.g. '*@example.com' Use '' to disable the blacklist. ", "");
        this._inviteEmailMaxMessageLength = container.defineFinalProperty("Settings/Invitation/invite email max message length", LongConverter.class, null, "The maximum number of characters in an invitation email. Default is 10000, but should be much lower for open platforms like cloud.just.social", "10000");
        this._defaultSiteTitle = container.defineFinalProperty("Settings/Default Title", SimpleStringConverter.class, null, "The default title of platform", "Just Social");
        this._systemMinDateYear = container.defineFinalProperty("Settings/min selectable system date Year", LongConverter.class, null, "The min. year we are accepted in the date time select Widgets.\nThese Widgets are use in appointments during creating and filtering.", "1950");
        this._systemMaxDateYear = container.defineFinalProperty("Settings/max selectable system date Year", LongConverter.class, null, "The max. year we are accepted in the date time select Widgets.\nThese Widgets are use in appointments during creating and filtering.", "2050");
        this._defaultEntityId = container.defineFinalProperty("Settings/Registration/Default Entity Id", LongConverter.class, null, "Defines the default entity id for registration.\nA new registered user without an explicitly selected entity will become a member of this entity.\nIf you don't want to define a default entity, use the id -1.", "1");
        this._registrationAutoJoinEntityIds = container.defineFinalProperty("Settings/registration auto join entities", CollectionConverter.class, null, "Your can define entity id in this list. \nUsers who will register a new account will automatically join \nthe entities you have define here. If you want to automatically join to all entities of type network,\nenter NETWORK instead an entity id. Attion: only use the all NETWORK or other entity type options, if you are\nsure, that the amount of this entity type is not too big. Too much automatically invitation may cause\nperformance issues. Available entity types are:\nNETWORK, GROUP, WIKI, APPOINTMENT, PUBLICATION", "");
        this._activeFilterTypes = container.defineFinalProperty("Settings/Search/active filter types", FilterTypeCollectionConverter.class, null, "A comma separated list of filter types available for the search. The values defined here are always shown to the user in the filter box. \nPossible values are: \nALL,PROFILES,DOCUMENTS,POST,WORKSTREAMS,CHATS,ENTITY_*.\nTo include certain entity types in this list use the notation ENTITY_* and replace '*' with the entity name defined in the configuration file.", "ALL,PROFILES,DOCUMENTS,WORKSTREAMS,ENTITY_GROUP,ENTITY_NETWORK,WIKI_WIKIS,WIKI_CHAPTERS,WIKI_ARTICLES");
        this._collapseToRestrictingFilters = container.defineFinalProperty("Settings/Search/collapse to restricting filters", BooleanConverter.class, null, "If enabled the show less link in the search filter panel will collapse all unrestricting filters and show only filters which are limiting the result. If disabled collapse will hide all filters.", "false");
        this._alwaysShowSearchContextFilter = container.defineFinalProperty("Settings/Search/always show search context filter", BooleanConverter.class, null, "If enabled: Always show my search context filter and the entity search context filter", "false");
        this._importPersonsEnabled = container.defineFinalProperty("Settings/Migration/Import/import persons enabled", BooleanConverter.class, null, "Switch for enabling a data import of persons from external sources.", "false");
        this._importMembershipDefaultEntityIds = container.defineFinalProperty("Settings/Migration/Import/person import membership default entity ids", CollectionConverter.class, null, "Specifies a list of entity ids that are used as defaultEntities in membership imports (if not explicitly deactivated in membership import). Example: 1,4711.", "");
        this._importPassiveSubscriptionDefaultEntityIds = container.defineFinalProperty("Settings/Migration/Import/person import passive subscription default entity ids", CollectionConverter.class, null, "Specifies a list of entity ids that are used as defaultEntities in passive subsciption imports (if not explicitly deactivated in subscription import). Example: 1,4711.", "");
        this._importRecommendedSubscriptionDefaultEntityIds = container.defineFinalProperty("Settings/Migration/Import/person import recommended subscription default entity ids", CollectionConverter.class, null, "Specifies a list of entity ids that are used as defaultEntities in recommended subsciption imports (if not explicitly deactivated in subscription import). Example: 1,4711.", "");
        this._importDefaultStaticRoles = container.defineFinalProperty("Settings/Migration/Import/person import default static roles", CollectionConverter.class, null, "Specifies a list of static roles that are used as default roles in static role imports. Example: INTERN.", "");
        this._importUserGroupsEnabled = container.defineFinalProperty("Settings/Migration/Import/import user groups enabled", BooleanConverter.class, null, "Switch for enabling a data import of user groups from external sources.", "false");
        this._importQueueCronJobExpression = container.defineFinalProperty("Settings/Migration/Import/import queue cron job expression ", SimpleStringConverter.class, null, "The cron job expresssion for the import queue. The format is <sec.> <min.> <hour> <day of month> <month> <day of week>. The default is \"0 0 3 * * ?\" which is every day, 3 o'clock in the morning.An empty value will import never", "0 0 3 * * ?");
        this._failedImportResultRecipient = container.defineFinalProperty("Settings/Migration/Import/failed import result recipient", SimpleStringConverter.class, null, "E-Mail address of the user that should be notified should the import fail.", "");
        this._migrationBatchSize = container.defineFinalProperty("Settings/Migration/migration batch size", LongConverter.class, null, "The batch size for fetching persons for the  export and import", "1000");
        this._migrationLdapExportCronJobExpression = container.defineFinalProperty("Settings/Migration/Export/ldap export cron job expression ", SimpleStringConverter.class, null, "The cron job expression for the ldap export (s m h dom mon dow). Empty to disable.", "0 * 8-22 * * ?");
        this._googleAnalyticsAccount = container.defineFinalProperty("Settings/google analytics account", SimpleStringConverter.class, null, "Enter your google analytics account here (e.g. 'UA-2862268-12')", "");
        this._additionalTermsAcceptanceRequired = container.defineFinalProperty("Settings/Registration/additional terms acceptance required", BooleanConverter.class, null, "Switch to make the acceptance of additional terms within the registration mandatory.", "false");
        this._termsAcceptanceRequired = container.defineFinalProperty("Settings/Registration/terms acceptance required", BooleanConverter.class, null, "Switch to make the acceptance terms within the registration mandatory.", "false");
        this._activationViaOptInEnabled = container.defineFinalProperty("Settings/Registration/activation via opt-in enabled", BooleanConverter.class, null, "Switch to enable the activation via opt-in for a new registered account. If set to true, the usermust click on the link in the received activation email to activate his account after registration.", "false");
        this._registrationAutoJoinForParentEntitiesEnabled = container.defineFinalProperty("Settings/Registration/registration auto join for parent entities enabled", BooleanConverter.class, null, "Switch to enable automatic join to parent entities during registration.", "true");
        this._isClientLoggingEnable = container.defineFinalProperty("Settings/client logging", BooleanConverter.class, null, "True, if you want get javascript logging on client side", "false");
        this._defaultLanguage = container.defineFinalProperty("Settings/default language", SimpleStringConverter.class, null, "The default language we used, if we got an unknown language", "de");
        this._favIcon = container.defineFinalProperty("Settings/favIcon/url", SimpleStringConverter.class, null, "The Url of the favIcon", "/toro/www/favicon.png");
        this._showProductHints = container.defineFinalProperty("Settings/Horizontal Navigation/show product hints", EnumConverter.class, ProductHintsOption.class.getName(), "If and how to show product hints to the user.", ProductHintsOption.OFF.name());
        this._searchContextShown = container.defineFinalProperty("Settings/Search/show search context", BooleanConverter.class, null, "Show the search context on the search page?", "false");
        this._showFooterPageTermsInSameWindow = container.defineFinalProperty("Settings/footer/show terms in same window", BooleanConverter.class, null, "True if you want to open the terms page in the same browser window.", "true");
        this._showFooterPageDataProtectionInSameWindow = container.defineFinalProperty("Settings/footer/show data protection in same window", BooleanConverter.class, null, "True if you want to open the data protection page in the same browser window.", "true");
        this._showFooterPageHelpInSameWindow = container.defineFinalProperty("Settings/footer/show help page in same window", BooleanConverter.class, null, "True if you want to open the help page in the same browser window.", "true");
        this._showFooterPageImprintInSameWindow = container.defineFinalProperty("Settings/footer/show imprint page in same window", BooleanConverter.class, null, "True if you want to open the imprint page in the same browser window.", "true");
        this._showFooterPagePressInSameWindow = container.defineFinalProperty("Settings/footer/show press page in same window", BooleanConverter.class, null, "True if you want to open the press page in the same browser window.", "true");
        this._showFooterPageAboutInSametWindow = container.defineFinalProperty("Settings/footer/show about page in same window", BooleanConverter.class, null, "True if you want to open the about page in the same browser window.", "true");
        this._showFooterPageArticleOfAssociationInSameWindow = container.defineFinalProperty("Settings/footer/show article of association page in same window", BooleanConverter.class, null, "True if you want to open the article of association page in the same browser window.", "true");
        this._displayEntityTypeInBreadCrumbs = container.defineFinalProperty("Settings/Breadcrumb/display entity type in breadcrumbs", BooleanConverter.class, null, "True if you want to display the entity type in the breadcrumbs of entities pages", "false");
        this._modificationRestrictedPersonFields = container.defineFinalProperty("Settings/profile/modificationRestrictedPersonFields", CollectionConverter.class, null, "Contains the list of person fields that are not allowed to be modified by the user.\nas defined in de.justsoftware.onx.person.model.PersonFields.", "");
        this._hiddenPersonFields = container.defineFinalProperty("Settings/profile/hiddenPersonFields", CollectionConverter.class, null, "Contains a list of person fields that are not visible to users.", "person.home-city,person.current-city,person.home-country,person.current-country,person.title,person.additionalTitle,person.timezone,person.birthday");
        this._isPasswordResetEnabled = container.defineFinalProperty("Settings/login/isPasswordResetEnabled", BooleanConverter.class, null, "Set this property to true if password reset functionality is enabled.", "true");
        this._adfsEnabled = container.defineFinalProperty("Settings/login/ADFS enabled", BooleanConverter.class, null, "Set this property to true, to enable ADFS SSO", "false");
        this._defaultPowerBarOption = container.defineFinalProperty("Settings/profile/defaultPowerBarOption", BooleanConverter.class, null, "defines the default setting of the powerbar", "false");
        this._ordinaryUsersMayInviteMembers = container.defineFinalProperty("Settings/ordinary users may invite members", BooleanConverter.class, null, "Indicates whether non-admins of an entity may invite all the members of that entity into another entity. If false then only admins and the super-admin may do this.", "true");
        this._personIdForAdminTransfer = container.defineFinalProperty("Settings/profile/personIdForAdminTransfer", LongConverter.class, null, "The id of the person to transfer the admin rights to when deleting a person with admin rights.\nIf = -1 no transfer will be performed.", "-1");
        this._mailReceivingRolesWhenProfileBlockedList = container.defineFinalProperty("Settings/profile/mailReceiversWhenProfileIsSetBlocked", CollectionConverter.class, null, "A list of role names. All persons who are in at least one of these roles will receive a notification email\nwhen an arbitrary person is set blocked.\nThe role names to be entered must match the role names as stated in database table 'person_roles'.", "SUPERADMIN");
        this._newChatMessagesEmailSenderCronExpr = container.defineFinalProperty("Settings/Chat/newChatMessagesEmailSenderCronExpr", SimpleStringConverter.class, null, "The cron job expresssion for the unread chat message email sender (seconds minutes hours day_of_month month day_of_week)\nSee also: http://www.quartz-scheduler.org/documentation/quartz-1.8.6/tutorials/TutorialLesson06", "0 0/30 * * * ?");
        this._cleanupChatsAfter = container.defineFinalProperty("Settings/Chat/cleanupChatsAfter", SimpleStringConverter.class, null, "Cleanup deleted Opticon Chats after x days", "90");
        this._cleanupWikiAfter = container.defineFinalProperty("Settings/Wiki/cleanupWikiAfter", SimpleStringConverter.class, null, "Cleanup deleted Wiki Articles/Chapters/Wikis:\nnegative values = disabled\n0 value = enabled and delete immediately\npositive values = enabled and delete after x days", "-1");
        this._inheritedSubscriptionForMembersOnJoin = container.defineFinalProperty("Settings/subscriptions/auto/member/on join", BooleanConverter.class, null, "Defines whether a new member of an entity should be subscribed to all entities that inherit this new member as well", "false");
        this._inheritedSubscriptionForAdminsOnJoin = container.defineFinalProperty("Settings/subscriptions/auto/admin/on join", BooleanConverter.class, null, "Defines whether a new admin or co-admin of an entity should be subscribed to all entities that inherit this new co-admin as well", "false");
        this._inheritedSubscriptionForMembersOnEntityUpdate = container.defineFinalProperty("Settings/subscriptions/auto/member/on entity update", BooleanConverter.class, null, "Defines whether a change to the inheritence tree of entities should also subscribe any newly inherited members", "false");
        this._inheritedSubscriptionForAdminsOnEntityUpdate = container.defineFinalProperty("Settings/subscriptions/auto/admin/on entity update", BooleanConverter.class, null, "Defines whether a change to the inheritence tree of entities should also subscribe any newly inherited co-admins", "false");
        this._showBirthdaysOnStartPage = container.defineFinalProperty("Settings/Startpage/showBirthdaysOnStartPage", RegexpCheckConverter.class, SuperopertySettings.regexForEnum(ShowBirthdayOption.class), "define which users can be shown in the birthday widget, possible values are:\nPLATFORM - all users of the platform are shown\nFRIENDS - only friends are shown\nNONE - the widget is not shown\n", "PLATFORM");
        this._myContentTeaserCount = container.defineFinalProperty("Settings/Menu/'my contents' teaser count", LongConverter.class, null, "Defines how many teasers are displayed in the 'my contents' section of the left menu.", "100");
        this._csvExportColumns = container.defineFinalProperty("Settings/CSV export columns", CollectionConverter.class, null, "Defines the list of fields that shall be exported into the CSV file that can be generated in the member settings of each entity", "ENTITY_NAME,PERSON_ID,PERSON_FIRST_NAME,PERSON_LAST_NAME,BASIC.profileStatusLabel,PERSON_IS_ACTIVE,MEMBER_STATUS,email,tel,mobile,fax,room,building,street,plz,city");
        this._ordinaryUsersMayRecommendToMembers = container.defineFinalProperty("Settings/Recommendation/ordinary users may recommend to members", BooleanConverter.class, null, "Indicates whether non-admins of an entity may recommend another entity to all the members of that entity. If\n false then only admins and the super-admin may do this.", "true");
        this._entityTypesToAddUsersAsMembersOnRecommendationTask = container.defineFinalProperty("Settings/Recommendation/entities to add users as members upon recommendation task", CollectionConverter.class, null, "If an entity of the types listed here is recommended to users, who are not allowed to see the recommended entity,\nthese users are added to the member list of the recommended entity.\nThis is done in order to ensure that the users can see the entity.\nThey are not added if they can already read the entity details without membership.\nBe careful with this setting as the adding of new members might not be obvious to the users of the recommendation feature.\nThe list is comma separated, e.g. NETWORK,GROUP\nBy default users are not added as members for any entity type.", "");
        this._registerPersonFields = container.defineFinalProperty("Settings/Registration/available person fields", CollectionConverter.class, null, "A list of person fields, that the user may enter during the registration.\nThe user may always enter the following fields. Those fields, however,\nmay be included in the list below, to change their order.\n  person.firstname\n  person.lastname\n  person.birthday\n  person.email\n  person.password", "person.firstname,person.lastname,person.email,person.password");
        this._blockUserAfterRegistration = container.defineFinalProperty("Settings/Registration/block user after registration", BooleanConverter.class, null, "Indicates whether newly registered users should be blocked. This is useful when users should get activated manually by an administrator.", "false");
        this._appFilesPort = container.defineFinalProperty("Settings/App/app files port", LongConverter.class, null, "Port of the url under which the app files for the wrapper app are loaded.", "80");
        this._appFilesBasePath = container.defineFinalProperty("Settings/App/app files base path", SimpleStringConverter.class, null, "Base path of the url under which the app files for the wrapper app are loaded. We handle leading and trailing slashes ('/') for you. So you don't need to worry about them.", "app-files/");
        this._dataRetentionMinimumTime = container.defineFinalProperty("Settings/Data Retention/minimum time", LongConverter.class, null, "Define the minimum time in minutes data should be kept in the shadow tables.\nTo never store data in the shadow tables, i.e. to delete all data immediately, set the amount to 0.\n", String.valueOf(Integer.MAX_VALUE));
        this._dataRetentionDeleteTaskCronExpr = container.defineFinalProperty("Settings/Data Retention/Delete task cron expression", SimpleStringConverter.class, null, "The cron job expresssion for the task deleting old data from the shadow tables (seconds minutes hours day_of_month month day_of_week)\nSee also: http://www.quartz-scheduler.org/documentation/quartz-1.8.6/tutorials/TutorialLesson06", "0 0 6 * * ?");
        this._entityPreviewAmount = container.defineFinalProperty("Settings/rest/entity preview amount", EnumConverter.class, EntityPreviewAmount.class.getName(), "The default amount of entity preview data to return from the REST API (/entity/<ID>/preview", EntityPreviewAmount.BASIC.name());
        this._notificationMailCron = container.defineFinalProperty("Settings/Notification/mail cron", SimpleStringConverter.class, null, "Cron expression to schedule job to send unread notifications by mail.", "0 0 0 * * ?");
        this._sendPasswordResetCodeMailAfterRegistration = container.defineFinalProperty("Settings/Registration/send password reset code after registration", BooleanConverter.class, null, "If set to true, an email containing a password reset code link will be sent after successful registration.", "false");
        this._drivePublicLinksEnabled = container.defineFinalProperty("Settings/drive public links enabled", BooleanConverter.class, null, "Set to true, if users shall be able to share DRIVE files via publicly accessible links. When this is set to false, then already generated links are also not accessible, anymore.", "true");
        this._driveDocumentMigrationDate = container.defineFinalProperty("Settings/Drive/document migration date", DateTimeConverter.class, null, "The date of the document migration. This value is used to publish all entity document versions which are created before that timestamp. Only needed if all document-versions migrated from the old documents module must be marked as public.", null);
        this._driveUploadMaxFileSize = container.defineFinalProperty("Settings/Drive/maximum upload file size", SimpleStringConverter.class, null, "The maximum file size allowed for upload. Specify as data size, e.g. 1GB or 50MB. Please note that the value must NOT contain whitespace.", "250MB");
        this._driveUploadAllowedMimeTypes = container.defineFinalProperty("Settings/Drive/allowed mime-types for upload", SimpleStringConverter.class, null, "The mime-types of files that are allowed for upload (e.g. image/*,video/* if only images and videos are allowed). default empty, to allow all files.", "");
        this._historyCompactorCron = container.defineFinalProperty("Settings/Drive/drive history compactor cron", SimpleStringConverter.class, null, "Cron expression to schedule job for compacting Drive history. Leave empty to deactivate.", "0 0 5 * * SAT");
        this._piwikUrl = container.defineFinalProperty("Settings/Piwik/piwik url", SimpleStringConverter.class, null, "The base URL of the Piwik Server, e.g. https://piwik.just.social.", "https://piwik.just.social");
        this._piwikSiteId = container.defineFinalProperty("Settings/Piwik/site id", SimpleStringConverter.class, null, "The ID of the site to track as defined by Piwik. The ID is an integer number.", "");
        this._piwikTokenAuth = container.defineFinalProperty("Settings/Piwik/token auth", SimpleStringConverter.class, null, "The authentication token of a Piwik user with admin rights for the site. Can be found by clicking Administration (top of the page),then API in the left menu. You can find the token_auth value there, e.g. 05c6e233b08fd95bf2488232c13afcc6", "");
        this._deviceLockRequired = container.defineFinalProperty("Settings/mobile/require device lock to use app", BooleanConverter.class, null, "Prevent usage of our mobile apps if there is no device lock enabled on the user's phone.", "false");
        this._mobileSupportedLegacyEntityTypes = container.defineFinalProperty("Settings/mobile/supported legacy entity types", CollectionConverter.class, null, "Entity types of the legacy Wiki/Social app that are supported in the mobile webclient", "");
        this._browserPushServiceEnabled = container.defineFinalProperty("Settings/Feature Toggle/browser push service (SSE) enabled", BooleanConverter.class, null, "Feature Toggle for enabling the browser push service (SSE)", "true");
        this._isAccountLockEnabled = container.defineFinalProperty("Settings/Feature Toggle/security/account lock enabled", BooleanConverter.class, null, "Toggle for enabling account lockouts after too many failed login attempts.\nFailed attempts are counted and locks written to the DB even when this toggle is set to falsebut they are not enforced.", "true");
        this._isQuickPollsEnabled = container.defineFinalProperty("Settings/News/quick polls enabled", BooleanConverter.class, null, "toggle quick polls in news app", "true");
        this._isAdaSSOConfigEnabled = container.defineFinalProperty("Settings/Feature Toggle/admin/sso config enabled", BooleanConverter.class, null, "toggle HOIC / SSO / OpenId Connect config in ada", "true");
        this._isUserImpersonationEnabled = container.defineFinalProperty("Settings/login/user impersonation enabled", BooleanConverter.class, null, "When enabled, we can configure an oauth-client that will be allowed to issue JWTs for any non-admin user, effectively allowing to 'become' that user.", "false");
        this._driveDeletionDelay = container.defineFinalProperty("Settings/Drive/deletionDelay", SimpleStringConverter.class, null, "Cleanup deleted Shares after configured time (default 90d)", "90d");
        this._newsDeletionDelay = container.defineFinalProperty("Settings/News/deletionDelay", SimpleStringConverter.class, null, "Cleanup deleted News items after configured time (default 90d)", "90d");
    }

    private static String regexForEnum(@Nonnull Class<? extends Enum<?>> enumClz) {
        return "|" + Joiner.on((char)'|').join((Object[])enumClz.getEnumConstants());
    }

    private static int asInt(@Nonnull Property property) {
        return ((Number)property.getValue()).intValue();
    }

    private static long asLong(@Nonnull Property property) {
        return ((Number)property.getValue()).longValue();
    }

    @CheckForNull
    private static Integer asInteger(@Nonnull Property property) {
        Object value = property.getValue();
        if (value == null) {
            return null;
        }
        return ((Number)value).intValue();
    }

    @CheckForNull
    private static String asString(@Nonnull Property property) {
        return (String)property.getValue();
    }

    private static boolean asBoolean(@Nonnull Property property) {
        return Boolean.TRUE.equals(property.getValue());
    }

    @Nonnull
    private static <T> ImmutableSet<T> asSet(@Nonnull Property property) {
        Collection collection = (Collection)property.getValue();
        return ImmutableSet.copyOf((Collection)collection);
    }

    @Nonnull
    private static <T> ImmutableList<T> asList(@Nonnull Property property) {
        Collection collection = (Collection)property.getValue();
        return ImmutableList.copyOf((Collection)collection);
    }

    @Override
    public int getClientPollingInterval() {
        return SuperopertySettings.asInt(this._clientPollingInterval);
    }

    @Override
    public Property getClientPollingIntervalProperty() {
        return this._clientPollingInterval;
    }

    @Override
    public String getDefaultSiteTitle() {
        return SuperopertySettings.asString(this._defaultSiteTitle);
    }

    @Override
    public String getSmtpPassword() {
        return SuperopertySettings.asString(this._smtpPassword);
    }

    @Override
    public String getSmtpSender() {
        return SuperopertySettings.asString(this._smtpSender);
    }

    @Override
    public String getSmtpServer() {
        return SuperopertySettings.asString(this._smtpServer);
    }

    @Override
    public String getSmtpUsername() {
        return SuperopertySettings.asString(this._smtpUsername);
    }

    @Override
    public boolean isEnableTls() {
        return SuperopertySettings.asBoolean(this._enableTls);
    }

    @Override
    public ImmutableSet<String> getListUnsubscribeUrls() {
        return SuperopertySettings.asSet(this._listUnsubscribeUrls);
    }

    @Override
    public Long getSmtpPort() {
        return (Long)this._smtpPort.getValue();
    }

    @Override
    public ImmutableList<MenuLinkDefinition> getPageMenuLinks() {
        return SuperopertySettings.asList(this._pageMenuLinks);
    }

    @Override
    public boolean showIcons() {
        return SuperopertySettings.asBoolean(this._showIcons);
    }

    @Override
    public Property getAdfsEnabledProperty() {
        return this._adfsEnabled;
    }

    @Override
    public Property getImportPersonsEnabledProperty() {
        return this._importPersonsEnabled;
    }

    @Override
    public Property getMobileTrackingEnabledProperty() {
        return this._mobileTrackingEnabled;
    }

    @Override
    public boolean isMobileTrackingEnabled() {
        return SuperopertySettings.asBoolean(this._mobileTrackingEnabled);
    }

    @Override
    public TimeZone getDefaultTimeZone() {
        return SuperopertySettings.asEnum(this._defaultTimeZone, TimeZone.GERMANY);
    }

    @Override
    public String getEmailBlacklist() {
        return SuperopertySettings.asString(this._emailBlacklist);
    }

    @Override
    public Pattern getEmailBlacklistPattern() {
        String blacklistString = this.getEmailBlacklist();
        return Strings.isNullOrEmpty((String)blacklistString) ? null : RegExUtilServer.wildcardsListToRegEx(blacklistString);
    }

    @Override
    public int getInviteEmailMaxMessageLength() {
        return SuperopertySettings.asInt(this._inviteEmailMaxMessageLength);
    }

    @Override
    public String getRegisterEmailPattern() {
        return SuperopertySettings.asString(this._registerEmailPattern);
    }

    @Override
    public Pattern getRegisterEmailPatternRegEx() {
        return RegExUtilServer.wildcardsListToRegEx(this.getRegisterEmailPattern());
    }

    @Override
    public String getEmailPattern() {
        return this.getRegisterEmailPattern();
    }

    @Override
    public Pattern getEmailPatternRegEx() {
        return RegExUtilServer.wildcardsListToRegEx(this.getEmailPattern());
    }

    @Override
    public Integer getSystemMaxDateYear() {
        return SuperopertySettings.asInteger(this._systemMaxDateYear);
    }

    @Override
    public Integer getSystemMinDateYear() {
        return SuperopertySettings.asInteger(this._systemMinDateYear);
    }

    @Override
    public EntityId getDefaultEntityId() {
        Long id = (Long)this._defaultEntityId.getValue();
        if (id == null || id < 0L) {
            return null;
        }
        return new EntityId(id);
    }

    @Override
    public Collection<String> getRegistrationAutoJoinEntityIds() {
        return SuperopertySettings.asSet(this._registrationAutoJoinEntityIds);
    }

    @Override
    public Iterable<FilterType> getActiveFilterTypes() {
        return SuperopertySettings.asFilterTypeIterable(this._activeFilterTypes);
    }

    @Override
    public void registerActiveFilterTypesChangedListener(SuperopertyChangeListener listener) {
        this._activeFilterTypes.addSuperopertyChangeListener(listener);
    }

    @Override
    public boolean isCollapseToRestrictingFilters() {
        return SuperopertySettings.asBoolean(this._collapseToRestrictingFilters);
    }

    @Override
    public boolean isAlwaysShowSearchContextFilter() {
        return SuperopertySettings.asBoolean(this._alwaysShowSearchContextFilter);
    }

    @Nonnull
    private static Iterable<FilterType> asFilterTypeIterable(@Nonnull Property property) {
        Iterable value = (Iterable)property.getValue();
        return Iterables.filter((Iterable)Iterables.transform((Iterable)value, FilterTypes.VALUE_OF_FUNCTION), (Predicate)Predicates.notNull());
    }

    @Override
    public String getGoogleAnalyticsAccount() {
        return this._googleAnalyticsAccount.getStringValue();
    }

    @Override
    public boolean isImportPersonsEnabled() {
        return SuperopertySettings.asBoolean(this._importPersonsEnabled);
    }

    @Override
    public ImmutableSet<EntityId> getImportMembershipDefaultEntityIds() {
        return this.asEntityIdSet(this._importMembershipDefaultEntityIds);
    }

    @Override
    public ImmutableSet<String> getImportDefaultStaticRoles() {
        return SuperopertySettings.asSet(this._importDefaultStaticRoles);
    }

    @Override
    public String getLdapExportCronJobExpression() {
        return this._migrationLdapExportCronJobExpression.getStringValue();
    }

    @Override
    public Property getLdapExportCronJobExpressionProperty() {
        return this._migrationLdapExportCronJobExpression;
    }

    @Override
    public ImmutableSet<EntityId> getImportPassiveSubscriptionDefaultEntityIds() {
        return this.asEntityIdSet(this._importPassiveSubscriptionDefaultEntityIds);
    }

    @Override
    public ImmutableSet<EntityId> getImportRecommendedSubscriptionDefaultEntityIds() {
        return this.asEntityIdSet(this._importRecommendedSubscriptionDefaultEntityIds);
    }

    @Nonnull
    private ImmutableSet<EntityId> asEntityIdSet(Property entityIdsProperty) {
        ImmutableSet stringSet = SuperopertySettings.asSet(entityIdsProperty);
        return (ImmutableSet)stringSet.stream().map(EntityId::parse).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean isImportUserGroupsEnabled() {
        return SuperopertySettings.asBoolean(this._importUserGroupsEnabled);
    }

    @Override
    public String getImportQueueCronJobExpression() {
        return this._importQueueCronJobExpression.getStringValue();
    }

    @Override
    public Property getImportQueueCronJobExpressionProperty() {
        return this._importQueueCronJobExpression;
    }

    @Override
    public String getFailedImportResultRecipient() {
        return SuperopertySettings.asString(this._failedImportResultRecipient);
    }

    @Override
    public boolean isAdditionalTermsAcceptanceRequired() {
        return SuperopertySettings.asBoolean(this._additionalTermsAcceptanceRequired);
    }

    @Override
    public boolean isActivationViaOptInEnabled() {
        return SuperopertySettings.asBoolean(this._activationViaOptInEnabled);
    }

    @Override
    public boolean isTermsAcceptanceRequired() {
        return SuperopertySettings.asBoolean(this._termsAcceptanceRequired);
    }

    @Override
    public boolean isRegistrationAutoJoinForParentEntitiesEnabled() {
        return SuperopertySettings.asBoolean(this._registrationAutoJoinForParentEntitiesEnabled);
    }

    @Override
    public boolean isClientLoggingEnable() {
        return SuperopertySettings.asBoolean(this._isClientLoggingEnable);
    }

    @Override
    public String defaultLanguage() {
        return this._defaultLanguage.getStringValue();
    }

    @Override
    public String getFavIconUrl() {
        return this._favIcon.getStringValue();
    }

    @Override
    public int getMigrationBatchSize() {
        return SuperopertySettings.asInt(this._migrationBatchSize);
    }

    @Override
    public ProductHintsOption getShowProductHints() {
        return SuperopertySettings.asEnum(this._showProductHints, ProductHintsOption.OFF);
    }

    @Override
    public int getMaxDirectMessageLength() {
        return 10000;
    }

    @Override
    public boolean getSearchContextShown() {
        return SuperopertySettings.asBoolean(this._searchContextShown);
    }

    @Override
    public boolean isShowFooterPageTermsInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPageTermsInSameWindow);
    }

    @Override
    public boolean isShowFooterPageDataProtectionInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPageDataProtectionInSameWindow);
    }

    @Override
    public boolean isShowFooterPageHelpInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPageHelpInSameWindow);
    }

    @Override
    public boolean isShowFooterPageImprintInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPageImprintInSameWindow);
    }

    @Override
    public boolean isShowFooterPagePressInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPagePressInSameWindow);
    }

    @Override
    public boolean isShowFooterPageAboutInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPageAboutInSametWindow);
    }

    @Override
    public boolean isShowFooterPageArticleOfAssociationInSameWindow() {
        return SuperopertySettings.asBoolean(this._showFooterPageArticleOfAssociationInSameWindow);
    }

    @Override
    public boolean isDisplayEntityTypeInBreadCrumbs() {
        return SuperopertySettings.asBoolean(this._displayEntityTypeInBreadCrumbs);
    }

    @Override
    public ImmutableList<String> getModificationRestrictedPersonFields() {
        return SuperopertySettings.asList(this._modificationRestrictedPersonFields);
    }

    @Override
    public ImmutableSet<String> getHiddenPersonFields() {
        return SuperopertySettings.asSet(this._hiddenPersonFields);
    }

    @Override
    public boolean isPasswordResetEnabled() {
        return SuperopertySettings.asBoolean(this._isPasswordResetEnabled);
    }

    @Override
    public boolean isAdfsEnabled() {
        return SuperopertySettings.asBoolean(this._adfsEnabled);
    }

    @Override
    public Property isAdfsEnabledProperty() {
        return this._adfsEnabled;
    }

    @Override
    public boolean defaultPowerBarOption() {
        return SuperopertySettings.asBoolean(this._defaultPowerBarOption);
    }

    @Override
    public boolean isOrdinaryUsersMayInviteMembers() {
        return SuperopertySettings.asBoolean(this._ordinaryUsersMayInviteMembers);
    }

    @Override
    public PersonId getPersonIdForAdminTransfer() {
        Long configuredId = (Long)this._personIdForAdminTransfer.getValue();
        return Long.valueOf(-1L).equals(configuredId) ? null : PersonId.valueOf(configuredId);
    }

    @Override
    public List<String> getMailReceivingRolesWhenProfileBlockedList() {
        return SuperopertySettings.asList(this._mailReceivingRolesWhenProfileBlockedList);
    }

    @Override
    public Property getNewChatMessagesEmailSenderCronExpr() {
        return this._newChatMessagesEmailSenderCronExpr;
    }

    @Override
    public Property getCleanupChatsAfter() {
        return this._cleanupChatsAfter;
    }

    @Override
    public Property getCleanupWikiAfter() {
        return this._cleanupWikiAfter;
    }

    @Override
    public boolean getInheritedSubscriptionForMembersOnJoin() {
        return SuperopertySettings.asBoolean(this._inheritedSubscriptionForMembersOnJoin);
    }

    @Override
    public boolean getInheritedSubscriptionForAdminsOnJoin() {
        return SuperopertySettings.asBoolean(this._inheritedSubscriptionForAdminsOnJoin);
    }

    @Override
    public boolean getInheritedSubscriptionForMembersOnEntityUpdate() {
        return SuperopertySettings.asBoolean(this._inheritedSubscriptionForMembersOnEntityUpdate);
    }

    @Override
    public boolean getInheritedSubscriptionForAdminsOnEntityUpdate() {
        return SuperopertySettings.asBoolean(this._inheritedSubscriptionForAdminsOnEntityUpdate);
    }

    @Override
    public ShowBirthdayOption getShowBirthdaysOnStartPage() {
        return SuperopertySettings.asEnum(this._showBirthdaysOnStartPage, ShowBirthdayOption.FRIENDS);
    }

    @Nonnull
    private static <E extends Enum<E>> E asEnum(Property property, @Nonnull E defaultValue) {
        Class<E> enumClz = defaultValue.getDeclaringClass();
        Object result = property.getValue();
        if (result == null) {
            return defaultValue;
        }
        if (enumClz.isAssignableFrom(result.getClass())) {
            Enum casted = (Enum)result;
            return (E)casted;
        }
        try {
            return Enum.valueOf(enumClz, property.getStringValue());
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    @Override
    public int getImageIconSmallSizeX() {
        return 16;
    }

    @Override
    public int getImageIconSmallSizeY() {
        return 16;
    }

    @Override
    public int getMyContentTeaserCount() {
        return SuperopertySettings.asInt(this._myContentTeaserCount);
    }

    @Override
    public Iterable<String> getCSVExportColumns() {
        return SuperopertySettings.asList(this._csvExportColumns);
    }

    @Override
    public boolean isProfileImageLegalAgreementRequired() {
        return SuperopertySettings.asBoolean(this._isProfileImageLegalAgreementRequired);
    }

    @Override
    public boolean isOrdinaryUsersMayRecommendToMembers() {
        return SuperopertySettings.asBoolean(this._ordinaryUsersMayRecommendToMembers);
    }

    @Override
    public ImmutableList<String> getConfiguredRegisterPersonFields() {
        return SuperopertySettings.asList(this._registerPersonFields);
    }

    @Override
    public boolean isBlockUserAfterRegistrationEnabled() {
        return SuperopertySettings.asBoolean(this._blockUserAfterRegistration);
    }

    @Override
    public int getSearchIndexFetchSize() {
        return SuperopertySettings.asInt(this._searchIndexFetchSize);
    }

    @Override
    public DateTime getWorkstreamReadMinDate() {
        return (DateTime)this._workstreamReadMinDate.getValue();
    }

    @Override
    public int getSearchIndexQueueMaxminutesInProcess() {
        return SuperopertySettings.asInt(this._searchIndexQueueMaxminutesInProcess);
    }

    @Override
    public int getAppFilesPort() {
        return SuperopertySettings.asInt(this._appFilesPort);
    }

    @Override
    public String getAppFilesBasePath() {
        return SuperopertySettings.asString(this._appFilesBasePath);
    }

    @Override
    public boolean isDeviceLockRequired() {
        return SuperopertySettings.asBoolean(this._deviceLockRequired);
    }

    @Override
    public ImmutableSet<EntityType> getSupportedLegacyEntityTypes() {
        return this.asEntityTypeSet(this._mobileSupportedLegacyEntityTypes);
    }

    @Nonnull
    private ImmutableSet<EntityType> asEntityTypeSet(Property entityTypesProperty) {
        ImmutableSet strings = SuperopertySettings.asSet(entityTypesProperty);
        return (ImmutableSet)strings.stream().map(EntityType::getEntityTypeByName).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public WorkstreamReadConfig getWorkstreamReadConfig() {
        return (WorkstreamReadConfig)((Object)MoreObjects.firstNonNull((Object)((Object)((WorkstreamReadConfig)((Object)this._workstreamReadPollingConfig.getValue()))), (Object)((Object)WorkstreamReadConfig.DISABLED)));
    }

    @Override
    public int getWorkstreamReadPollRatio() {
        return SuperopertySettings.asInt(this._workstreamReadPollRatio);
    }

    @Override
    public Property getWorkstreamReadConfigProperty() {
        return this._workstreamReadPollingConfig;
    }

    @Override
    public Duration getWorkstreamAggregateTimeLimit() {
        return ((Period)this._workstreamAggregateTimeLimit.getValue()).toStandardDuration();
    }

    @Override
    public int getDataRetentionMinimumTime() {
        return SuperopertySettings.asInt(this._dataRetentionMinimumTime);
    }

    @Override
    public Property getDataRetentionDeleteTaskCronExpr() {
        return this._dataRetentionDeleteTaskCronExpr;
    }

    @Override
    public EntityPreviewAmount entityPreviewAmount() {
        return SuperopertySettings.asEnum(this._entityPreviewAmount, EntityPreviewAmount.BASIC);
    }

    @Override
    public boolean sendPasswordResetCodeMailAfterRegistration() {
        return SuperopertySettings.asBoolean(this._sendPasswordResetCodeMailAfterRegistration);
    }

    @Override
    public Property drivePublicLinksEnabled() {
        return this._drivePublicLinksEnabled;
    }

    @Override
    public DateTime getDriveDocumentMigrationDate() {
        return (DateTime)this._driveDocumentMigrationDate.getValue();
    }

    @Override
    public Property driveUploadMaxFileSize() {
        return this._driveUploadMaxFileSize;
    }

    @Override
    public Property driveUploadAllowedMimeTypes() {
        return this._driveUploadAllowedMimeTypes;
    }

    @Override
    public Property getHistoryCompactorCron() {
        return this._historyCompactorCron;
    }

    @Override
    public LearnToRankToggleValue getLearnToRankEnabled() {
        return SuperopertySettings.asEnum(this._learnToRankEnabled, LearnToRankToggleValue.DISABLED);
    }

    @Override
    public int getLearnToRankReRankDocCount() {
        return SuperopertySettings.asInt(this._learnToRankReRankDocCount);
    }

    @Override
    public boolean isIndexPathEnabled() {
        return SuperopertySettings.asBoolean(this._indexPath);
    }

    @Override
    public Property getPiwikUrlProperty() {
        return this._piwikUrl;
    }

    @Override
    public Property getPiwikSiteIdProperty() {
        return this._piwikSiteId;
    }

    @Override
    public Property getPiwikTokenAuthProperty() {
        return this._piwikTokenAuth;
    }

    @Override
    public String getSuggestSearchQueryFields() {
        return SuperopertySettings.asString(this._searchSuggestQueryFields);
    }

    @Override
    public ImmutableSet<EntityType> entityTypesToAddUsersAsMembersOnRecommendationTask() {
        return this.asEntityTypeSet(this._entityTypesToAddUsersAsMembersOnRecommendationTask);
    }

    @Override
    public String getNotificationMailCron() {
        return SuperopertySettings.asString(this._notificationMailCron);
    }

    @Override
    public Property getNotificationMailCronProperty() {
        return this._notificationMailCron;
    }

    @Override
    public boolean isBrowserPushServiceEnabled() {
        return SuperopertySettings.asBoolean(this._browserPushServiceEnabled);
    }

    @Override
    public Property getBrowserPushServiceEnabledProperty() {
        return this._browserPushServiceEnabled;
    }

    @Override
    public boolean isAccountLockEnabled() {
        return SuperopertySettings.asBoolean(this._isAccountLockEnabled);
    }

    @Override
    public boolean isQuickPollsEnabled() {
        return SuperopertySettings.asBoolean(this._isQuickPollsEnabled);
    }

    @Override
    public Property getAdaSSOConfigEnabled() {
        return this._isAdaSSOConfigEnabled;
    }

    @Override
    public boolean isUserImpersonationEnabled() {
        return SuperopertySettings.asBoolean(this._isUserImpersonationEnabled);
    }

    @Override
    public Property getNewsDeletionDelay() {
        return this._newsDeletionDelay;
    }

    @Override
    public Property getDriveDeletionDelay() {
        return this._driveDeletionDelay;
    }
}

