/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container.editor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SGridLayout;
import org.wings.SLayoutManager;
import org.wings.SPanel;
import org.wings.STextField;
import org.wings.border.SBorder;
import org.wings.border.SLineBorder;

public class SetEditor
extends SPanel {
    private static final long serialVersionUID = 1L;
    private final STextField _keyTextField = new STextField();
    private final SButton _addButton = new SButton("add"){
        private static final long serialVersionUID = 1L;
        {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = SetEditor.this._keyTextField.getText();
                    SetEditor.this._textFields.add(SetEditor.this.createNewTextField(key));
                    SetEditor.this.update();
                }
            });
        }
    };
    private final LinkedList<STextField> _textFields = Lists.newLinkedList();
    private String _removeButtonText;
    private Color _textFieldColor;

    public SetEditor(Set<String> existing) {
        super((SLayoutManager)new SGridLayout(2));
        for (String s : existing) {
            this._textFields.add(this.createNewTextField(s));
        }
        this.update();
    }

    private STextField createNewTextField(String key) {
        STextField result = new STextField(key);
        this.applyTextFieldAttributes(result);
        return result;
    }

    private void applyTextFieldAttributes(STextField textField) {
        SLineBorder border = this._textFieldColor != null ? new SLineBorder(this._textFieldColor, 2) : null;
        textField.setBorder((SBorder)border);
    }

    public ImmutableSet<String> getValue() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (STextField textField : this._textFields) {
            String text = textField.getText();
            if (!StringUtils.isNotBlank((String)text)) continue;
            result.add((Object)text);
        }
        return result.build();
    }

    private void update() {
        this.removeAll();
        for (final STextField entry : this._textFields) {
            this.add((SComponent)entry);
            this.add((SComponent)new SButton(this._removeButtonText){
                private static final long serialVersionUID = 1L;
                {
                    super(arg0);
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SetEditor.this._textFields.remove(entry);
                            SetEditor.this.update();
                        }
                    });
                }
            });
        }
        this.add((SComponent)this._keyTextField);
        this.add((SComponent)this._addButton);
    }

    public void setTextFieldColor(Color color) {
        this._textFieldColor = color;
        this.applyTextFieldAttributes();
    }

    private void applyTextFieldAttributes() {
        for (STextField entry : this._textFields) {
            this.applyTextFieldAttributes(entry);
        }
    }

    public void setKeyTextFieldColor(Color color) {
        this._keyTextField.setBorder((SBorder)new SLineBorder(color, 2));
    }

    public void setKeyTextFieldSize(int size) {
        this._keyTextField.setColumns(size);
    }

    public void setAddButtonText(String s) {
        this._addButton.setText(s);
    }

    public void setRemoveButtonText(String s) {
        this._removeButtonText = s;
        this.update();
    }
}

