/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container.editor;

import com.freiheit.superoperty.container.MenulinksConverter;
import com.freiheit.superoperty.container.editor.MapEditor;
import com.freiheit.superoperty.container.editor.SetEditor;
import com.freiheit.superoperty.editor.UIEditorFactory;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.menu.server.model.AllEntitiesMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.CustomMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MyContentsMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MySubscribedPagesMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.StaticMenuLinkDefinition;
import de.justsoftware.onx.menu.shared.model.ExpandStatus;
import de.justsoftware.onx.menu.shared.model.MenuLinkLevel;
import de.justsoftware.onx.menu.shared.model.StaticMenuLink;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.wings.SBoxLayout;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SFlowLayout;
import org.wings.SGridLayout;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SList;
import org.wings.SPanel;
import org.wings.STabbedPane;
import org.wings.STextArea;
import org.wings.STextField;
import org.wings.border.SBorder;
import org.wings.border.SLineBorder;
import org.wings.script.JavaScriptListener;
import org.wings.script.ScriptListener;

public final class MenuLinksUIEditorFactory
implements UIEditorFactory {
    private static final Color LEVEL_COLOR = Color.ORANGE;
    private static final Color ICON_COLOR = Color.CYAN;
    private static final Color TYPE_COLOR = Color.GREEN;
    private static final Color STATIC_DROPDOWN_COLOR = Color.YELLOW;
    private static final Color URL_COLOR = Color.BLUE;
    private static final Color NEW_LOCALE_COLOR = Color.MAGENTA;
    private static final Color TRANSLATION_COLOR = Color.RED;
    private static final Color ENTITY_TYPE_COLOR = new Color(139, 69, 19);
    private static final Color ROLES_COLOR = Color.WHITE;
    private static final CustomMenuLinkDefinition DEFAULT_CUSTOM_LINK = new CustomMenuLinkDefinition(new MenuLinkLevel(0, ExpandStatus.DEFAULT), (ImmutableSet<String>)ImmutableSet.of((Object)"LOGGED_IN"), IconType.LINK, "", (ImmutableMap<String, String>)ImmutableMap.of((Object)"en", (Object)""));
    private final MenulinksConverter _menulinksConverter;
    private final boolean _hasLevels;

    public MenuLinksUIEditorFactory(MenulinksConverter menulinksConverter, boolean hasLevels) {
        this._menulinksConverter = menulinksConverter;
        this._hasLevels = hasLevels;
    }

    @Nonnull
    private static <T> SList createDropDown(T[] values, T initialValue, Color color) {
        SList list = new SList((Object[])values);
        list.setSelectionMode(0);
        list.setVisibleRowCount(1);
        list.setSelectedValue(initialValue);
        list.setBorder((SBorder)new SLineBorder(color.darker(), 2));
        list.setBackground(color);
        return list;
    }

    public String getUserHint() {
        return null;
    }

    public String extractEditedValue(SComponent component) {
        return ((MenuLinksEditorTabbedPane)component).getValue();
    }

    public SComponent createEditComponent(String s) {
        return new MenuLinksEditorTabbedPane(this._menulinksConverter, s, this._hasLevels);
    }

    private static enum TypedEditorComponentListFactory {
        CUSTOM{

            @Override
            TypedEditorComponentList createNewEditor(@Nullable MenuLinkDefinition menuLinkDefinition) {
                CustomMenuLinkDefinition definition = menuLinkDefinition instanceof CustomMenuLinkDefinition ? (CustomMenuLinkDefinition)menuLinkDefinition : DEFAULT_CUSTOM_LINK;
                final SList iconEditor = MenuLinksUIEditorFactory.createDropDown(IconType.values(), definition.getIcon(), ICON_COLOR);
                final STextField urlEditor = new STextField(definition.getUrl());
                urlEditor.setBorder((SBorder)new SLineBorder(URL_COLOR, 2));
                final MapEditor translationsEditor = new MapEditor((Map<String, String>)definition.getTranslations());
                translationsEditor.setKeyTextFieldColor(NEW_LOCALE_COLOR);
                translationsEditor.setTextFieldColor(TRANSLATION_COLOR);
                translationsEditor.setAddButtonText("add new locale");
                translationsEditor.setKeyTextFieldSize(1);
                translationsEditor.setRemoveButtonText("-");
                return new TypedEditorComponentList(new SComponent[]{iconEditor, urlEditor, translationsEditor}){
                    private static final long serialVersionUID = 1L;

                    @Override
                    MenuLinkDefinition getValue(LevelDropdownValues level, ImmutableSet<String> roles) {
                        MenuLinkLevel linkLevel = level != null ? new MenuLinkLevel(level._level, level._status) : null;
                        return new CustomMenuLinkDefinition(linkLevel, roles, (IconType)iconEditor.getSelectedValue(), urlEditor.getText(), translationsEditor.getValue());
                    }
                };
            }
        }
        ,
        STATIC{

            @Override
            TypedEditorComponentList createNewEditor(@Nullable MenuLinkDefinition menuLinkDefinition) {
                final SList type = MenuLinksUIEditorFactory.createDropDown(ImmutableList.copyOf(StaticMenuLink.nonDeprecated()).toArray(), menuLinkDefinition instanceof StaticMenuLinkDefinition ? ((StaticMenuLinkDefinition)menuLinkDefinition).getStaticMenuLink() : StaticMenuLink.STARTPAGE, STATIC_DROPDOWN_COLOR);
                return new TypedEditorComponentList(new SComponent[]{type}){
                    private static final long serialVersionUID = 1L;

                    @Override
                    MenuLinkDefinition getValue(LevelDropdownValues level, ImmutableSet<String> roles) {
                        MenuLinkLevel linkLevel = level != null ? new MenuLinkLevel(level._level, level._status) : null;
                        return new StaticMenuLinkDefinition(linkLevel, roles, (StaticMenuLink)type.getSelectedValue());
                    }
                };
            }
        }
        ,
        MY_CONTENTS{

            @Override
            TypedEditorComponentList createNewEditor(@Nullable MenuLinkDefinition menuLinkDefinition) {
                EntityType entityType = menuLinkDefinition instanceof MyContentsMenuLinkDefinition ? ((MyContentsMenuLinkDefinition)menuLinkDefinition).getEntityType() : EntityType.NETWORK;
                final STextField entityTypeEditor = new STextField(entityType.name());
                entityTypeEditor.setBorder((SBorder)new SLineBorder(ENTITY_TYPE_COLOR, 2));
                return new TypedEditorComponentList(new SComponent[]{entityTypeEditor}){
                    private static final long serialVersionUID = 1L;

                    @Override
                    MenuLinkDefinition getValue(LevelDropdownValues level, ImmutableSet<String> roles) {
                        MenuLinkLevel selectedLevel = level != null ? new MenuLinkLevel(level._level, level._status) : null;
                        EntityType selectedEntityType = EntityType.valueOf(entityTypeEditor.getText());
                        return new MyContentsMenuLinkDefinition(selectedLevel, roles, selectedEntityType);
                    }
                };
            }
        }
        ,
        ALL_ENTITIES{

            @Override
            TypedEditorComponentList createNewEditor(@Nullable MenuLinkDefinition menuLinkDefinition) {
                EntityType entityType = menuLinkDefinition instanceof AllEntitiesMenuLinkDefinition ? ((AllEntitiesMenuLinkDefinition)menuLinkDefinition).getEntityType() : EntityType.NETWORK;
                final STextField entityTypeEditor = new STextField(entityType.name());
                entityTypeEditor.setBorder((SBorder)new SLineBorder(ENTITY_TYPE_COLOR, 2));
                return new TypedEditorComponentList(new SComponent[]{entityTypeEditor}){
                    private static final long serialVersionUID = 1L;

                    @Override
                    MenuLinkDefinition getValue(LevelDropdownValues level, ImmutableSet<String> roles) {
                        MenuLinkLevel selectedLevel = level != null ? new MenuLinkLevel(level._level, level._status) : null;
                        EntityType selectedEntityType = EntityType.valueOf(entityTypeEditor.getText());
                        return new AllEntitiesMenuLinkDefinition(selectedLevel, roles, selectedEntityType);
                    }
                };
            }
        }
        ,
        MY_SUBSCRIBED_PAGES{

            @Override
            TypedEditorComponentList createNewEditor(MenuLinkDefinition menuLinkDefinition) {
                MySubscribedPagesMenuLinkDefinition definition = menuLinkDefinition instanceof MySubscribedPagesMenuLinkDefinition ? (MySubscribedPagesMenuLinkDefinition)menuLinkDefinition : null;
                EntityType rootEntityType = definition != null ? definition.getRootEntityType() : EntityType.NETWORK;
                IconType currentIcon = definition != null ? definition.getIcon() : IconType.HEART_EMPTY;
                final STextField rootEntityTypeEditor = new STextField(rootEntityType.name());
                rootEntityTypeEditor.setBorder((SBorder)new SLineBorder(ENTITY_TYPE_COLOR, 2));
                final SList iconEditor = MenuLinksUIEditorFactory.createDropDown(IconType.values(), currentIcon, ICON_COLOR);
                return new TypedEditorComponentList(new SComponent[]{iconEditor, rootEntityTypeEditor}){
                    private static final long serialVersionUID = 1L;

                    @Override
                    MenuLinkDefinition getValue(LevelDropdownValues level, ImmutableSet<String> roles) {
                        MenuLinkLevel selectedLevel = level != null ? new MenuLinkLevel(level._level, level._status) : null;
                        IconType icon = (IconType)iconEditor.getSelectedValue();
                        EntityType selectedEntityType = EntityType.valueOf(rootEntityTypeEditor.getText());
                        return new MySubscribedPagesMenuLinkDefinition(selectedLevel, roles, icon, selectedEntityType);
                    }
                };
            }
        };


        abstract TypedEditorComponentList createNewEditor(@Nullable MenuLinkDefinition var1);
    }

    private static abstract class TypedEditorComponentList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ImmutableList<SComponent> _components;

        TypedEditorComponentList(SComponent ... components) {
            this._components = ImmutableList.copyOf((Object[])components);
        }

        abstract MenuLinkDefinition getValue(@Nullable LevelDropdownValues var1, @Nonnull ImmutableSet<String> var2);
    }

    private static final class MenuLinksEditorRowPanel
    extends SPanel {
        private static final long serialVersionUID = 1L;
        private final HashMap<TypedEditorComponentListFactory, MenuLinkDefinition> _cached = Maps.newHashMap();
        private final SList _typeSelector;
        private final SList _level;
        private final SButton _sortUpButton = new SButton("\u2191");
        private final SButton _sortDownButton = new SButton("\u2193");
        private final SButton _removeButton = new SButton("remove");
        private final SetEditor _roles;
        private TypedEditorComponentListFactory _lastSelectedType;
        private TypedEditorComponentList _currentEditor = null;

        private MenuLinksEditorRowPanel(MenuLinksEditorPanel parent, MenuLinkDefinition definition, boolean hasLevels) {
            SBoxLayout layout = new SBoxLayout(0);
            layout.setHgap(2);
            layout.setVgap(2);
            this.setLayout((SLayoutManager)layout);
            this.setHorizontalAlignment(0);
            this.setBorder((SBorder)new SLineBorder(1));
            this._lastSelectedType = definition.accept(new MenuLinkDefinition.StaticDefaultVisitor<TypedEditorComponentListFactory>(){

                @Override
                public TypedEditorComponentListFactory visitCustomLink(CustomMenuLinkDefinition customLink) {
                    return TypedEditorComponentListFactory.CUSTOM;
                }

                @Override
                public TypedEditorComponentListFactory visitMyContentsLink(MyContentsMenuLinkDefinition myContentLink) {
                    return TypedEditorComponentListFactory.MY_CONTENTS;
                }

                @Override
                public TypedEditorComponentListFactory visitAllEntitiesLink(AllEntitiesMenuLinkDefinition allEntitiesLink) {
                    return TypedEditorComponentListFactory.ALL_ENTITIES;
                }

                @Override
                public TypedEditorComponentListFactory visitMySubscribedPagesLink(MySubscribedPagesMenuLinkDefinition link) {
                    return TypedEditorComponentListFactory.MY_SUBSCRIBED_PAGES;
                }

                @Override
                protected TypedEditorComponentListFactory visitStatic(StaticMenuLinkDefinition s) {
                    return TypedEditorComponentListFactory.STATIC;
                }
            });
            MenuLinkLevel linkLevel = definition.getLinkLevel();
            this._level = hasLevels && linkLevel != null ? MenuLinksUIEditorFactory.createDropDown(LevelDropdownValues.values(), LevelDropdownValues.valueOf(linkLevel.getLevel(), linkLevel.getExpandStatus()), LEVEL_COLOR) : null;
            this._roles = new SetEditor((Set<String>)definition.getRoles());
            this._roles.setTextFieldColor(ROLES_COLOR);
            this._roles.setAddButtonText("add role");
            this._roles.setRemoveButtonText("remove role");
            this._typeSelector = MenuLinksUIEditorFactory.createDropDown(TypedEditorComponentListFactory.values(), this._lastSelectedType, TYPE_COLOR);
            this._typeSelector.addScriptListener((ScriptListener)JavaScriptListener.JS_ON_CHANGE_SUBMIT_FORM);
            this._typeSelector.addListSelectionListener(e -> this.update(this._currentEditor.getValue(this.getLevel(), this.getRoles())));
            this._removeButton.addActionListener(e -> parent.removeRow(this));
            this._removeButton.setHorizontalAlignment(1);
            this._sortDownButton.addActionListener(e -> parent.moveDown(this));
            this._sortUpButton.addActionListener(e -> parent.moveUp(this));
            this.update(definition);
        }

        @CheckForNull
        private LevelDropdownValues getLevel() {
            return this._level != null ? (LevelDropdownValues)((Object)this._level.getSelectedValue()) : null;
        }

        private ImmutableSet<String> getRoles() {
            return this._roles.getValue();
        }

        private void update(MenuLinkDefinition lastValue) {
            this._cached.put(this._lastSelectedType, lastValue);
            this._lastSelectedType = (TypedEditorComponentListFactory)((Object)this._typeSelector.getSelectedValue());
            this._currentEditor = this._lastSelectedType.createNewEditor(this._cached.get((Object)this._lastSelectedType));
            this.removeAll();
            this.add((SComponent)this._sortUpButton);
            this.add((SComponent)this._sortDownButton);
            if (this._level != null) {
                this.add((SComponent)this._level);
            }
            this.add((SComponent)this._typeSelector);
            for (SComponent component : this._currentEditor._components) {
                this.add(component);
            }
            this.add((SComponent)this._roles);
            this.add((SComponent)this._removeButton);
        }
    }

    static enum LevelDropdownValues {
        ROOT_ALWAYS_EXPANDED(0, ExpandStatus.ALWAYS_EXPANDED),
        ROOT_EXPANDED(0, ExpandStatus.EXPANDED),
        ROOT_COLLAPSED(0, ExpandStatus.COLLAPSED),
        LEVEL_2(1, ExpandStatus.DEFAULT);

        final int _level;
        final ExpandStatus _status;

        private LevelDropdownValues(int level, ExpandStatus status) {
            this._level = level;
            this._status = status;
        }

        @Nonnull
        public static LevelDropdownValues valueOf(int level, ExpandStatus expandStatus) {
            if (level > 0) {
                return LEVEL_2;
            }
            switch (expandStatus) {
                case ALWAYS_EXPANDED: {
                    return ROOT_ALWAYS_EXPANDED;
                }
                case COLLAPSED: {
                    return ROOT_COLLAPSED;
                }
                case EXPANDED: {
                    return ROOT_EXPANDED;
                }
            }
            throw new UnsupportedOperationException("ExpandStatus \"" + expandStatus + "\" is not defined!");
        }
    }

    private static final class MenuLinksEditorPanel
    extends SPanel {
        private static final long serialVersionUID = 1L;
        private final List<MenuLinksEditorRowPanel> _rows = Lists.newLinkedList();
        private final SButton _button = new SButton("add row"){
            private static final long serialVersionUID = 1L;
            {
                super(arg0);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MenuLinkLevel newLinkLevel = _hasLevels ? new MenuLinkLevel(0, ExpandStatus.DEFAULT) : null;
                        this.addRow(new StaticMenuLinkDefinition(newLinkLevel, (ImmutableSet<String>)ImmutableSet.of((Object)"LOGGED_IN"), StaticMenuLink.STARTPAGE));
                        this.update();
                    }
                });
            }
        };
        private final SPanel _legend = new SPanel((SLayoutManager)new SFlowLayout(0, 2, 2));
        private final boolean _hasLevels;

        private MenuLinksEditorPanel(ImmutableList<MenuLinkDefinition> list, boolean hasLevels) {
            super((SLayoutManager)new SGridLayout(1));
            this._hasLevels = hasLevels;
            this.setHorizontalAlignment(0);
            this._legend.add((SComponent)new SLabel("legend:"));
            if (hasLevels) {
                this.legendLabelDropdown(LEVEL_COLOR, "level");
            }
            this.legendLabelDropdown(TYPE_COLOR, "type");
            this.legendLabelTextField(ROLES_COLOR, "roles");
            this.legendLabelDropdown(ICON_COLOR, "icon");
            this.legendLabelDropdown(STATIC_DROPDOWN_COLOR, "static link type");
            this.legendLabelTextField(ENTITY_TYPE_COLOR, "entity type");
            this.legendLabelTextField(URL_COLOR, "url");
            this.legendLabelTextField(NEW_LOCALE_COLOR, "new locale");
            this.legendLabelTextField(TRANSLATION_COLOR, "translation");
            this.setValue(list);
        }

        private void update() {
            this.removeAll();
            for (MenuLinksEditorRowPanel row : this._rows) {
                this.add((SComponent)row);
            }
            this.add((SComponent)this._button);
            this.add((SComponent)this._legend);
        }

        private void legendLabelTextField(Color color, String text) {
            STextField textField = new STextField(text);
            textField.setBorder((SBorder)new SLineBorder(color, 2));
            textField.setEditable(false);
            this._legend.add((SComponent)textField);
        }

        private void legendLabelDropdown(Color color, String text) {
            SList dd = MenuLinksUIEditorFactory.createDropDown(new String[]{text}, text, color);
            dd.setEnabled(false);
            this._legend.add((SComponent)dd);
        }

        private void addRow(MenuLinkDefinition link) {
            this._rows.add(new MenuLinksEditorRowPanel(this, link, this._hasLevels));
        }

        private void removeRow(MenuLinksEditorRowPanel row) {
            this._rows.remove((Object)row);
            this.update();
        }

        public void moveDown(MenuLinksEditorRowPanel row) {
            CollectionUtil.moveDown(this._rows, row);
            this.update();
        }

        public void moveUp(MenuLinksEditorRowPanel row) {
            CollectionUtil.moveUp(this._rows, row);
            this.update();
        }

        public void setValue(ImmutableList<MenuLinkDefinition> value) {
            this._rows.clear();
            for (MenuLinkDefinition link : value) {
                this.addRow(link);
            }
            this.update();
        }

        public ImmutableList<MenuLinkDefinition> getValue() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (MenuLinksEditorRowPanel row : this._rows) {
                TypedEditorComponentList currentEditor = row._currentEditor;
                if (currentEditor == null) continue;
                result.add((Object)currentEditor.getValue(row.getLevel(), row.getRoles()));
            }
            return result.build();
        }
    }

    private static final class MenuLinksEditorTabbedPane
    extends STabbedPane {
        private static final long serialVersionUID = 1L;
        private static final int EDITOR_INDEX = 0;
        private static final int JSON_TEXTAREA_INDEX = 1;
        private final MenulinksConverter _menulinksConverter;
        private final MenuLinksEditorPanel _menuLinksEditorPanel;
        private final STextArea _jsonTextArea = new STextArea(40, 80);

        MenuLinksEditorTabbedPane(@Nonnull MenulinksConverter converter, @Nonnull String value, boolean hasLevels) {
            this._menulinksConverter = converter;
            SPanel jsonViewPanel = new SPanel((SLayoutManager)new SGridLayout(1));
            this._jsonTextArea.setText(value);
            jsonViewPanel.add((SComponent)this._jsonTextArea);
            this._menuLinksEditorPanel = new MenuLinksEditorPanel(converter.convertToObject(value), hasLevels);
            this.addChangeListener(e -> {
                switch (this.getSelectedIndex()) {
                    case 0: {
                        this._menuLinksEditorPanel.setValue(converter.convertToObject(this._jsonTextArea.getText()));
                        break;
                    }
                    case 1: {
                        this._jsonTextArea.setText(converter.convertFromObjects((Collection<? extends MenuLinkDefinition>)this._menuLinksEditorPanel.getValue()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("An unsupported index was selected: " + this.getSelectedIndex());
                    }
                }
            });
            this.add((SComponent)this._menuLinksEditorPanel, "Editor", 0);
            this.add((SComponent)jsonViewPanel, "JSON", 1);
        }

        @Nonnull
        public String getValue() {
            if (this.getSelectedIndex() == 0) {
                return this._menulinksConverter.convertFromObjects((Collection<? extends MenuLinkDefinition>)this._menuLinksEditorPanel.getValue());
            }
            return this._jsonTextArea.getText();
        }
    }
}

