/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container;

import com.freiheit.superoperty.converter.SimpleStringConverter;
import com.freiheit.superoperty.editor.TextareaEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;

public class UnlimitedStringConverter
extends SimpleStringConverter {
    private static final int DEFAULT_LIMIT = 20000;

    protected UnlimitedStringConverter(int minLen, int maxLen, boolean mayBeNull) {
        super(minLen, maxLen, mayBeNull);
    }

    public UnlimitedStringConverter() {
        this(0, 20000, false);
    }

    public String checkValid(String storeString) throws IllegalArgumentException {
        if (!this._mayBeNull && storeString == null) {
            throw new IllegalArgumentException("Der String darf nicht NULL sein.");
        }
        if (storeString != null) {
            int strLen = storeString.length();
            if (this._maxLength >= 0 && strLen > this._maxLength) {
                throw new IllegalArgumentException("Text (L\u00e4nge " + strLen + ") l\u00e4nger als " + this._maxLength + " Zeichen");
            }
            if (this._minLength > 0 && strLen < this._minLength) {
                throw new IllegalArgumentException("Text (L\u00e4nge " + strLen + ")  unterschreitet " + this._minLength + " Zeichen");
            }
        }
        return storeString;
    }

    protected UIEditorFactory createEditorFactory() {
        return new TextareaEditorFactory("Ein String", 49, 40);
    }
}

