/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.converter.ListProvider;
import com.freiheit.superoperty.editor.ListEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;
import org.apache.commons.lang.StringUtils;

public class EnumConverter<E extends Enum<E>>
implements PropertyStringConverter,
ListProvider {
    private Class<E> _enum;

    public String checkValid(String stringRepresentation) throws IllegalArgumentException {
        return this.convertFromObject(stringRepresentation);
    }

    public Object convertToObject(String stringRepresentation) {
        if (StringUtils.isBlank((String)stringRepresentation)) {
            return null;
        }
        return Enum.valueOf(this._enum, stringRepresentation);
    }

    public String convertFromObject(Object o) throws ClassCastException {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public UIEditorFactory getEditorFactory() {
        return new ListEditorFactory((ListProvider)this);
    }

    public void setConfiguration(String param) {
        try {
            Class<?> clz = Class.forName(param);
            if (!clz.isEnum()) {
                throw new IllegalArgumentException(clz + " isn't an enum");
            }
            this._enum = clz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(param + " class not found, you have to provide an existing enum");
        }
    }

    public String[][] getListItems() {
        Enum[] enumConstants = (Enum[])this._enum.getEnumConstants();
        String[][] result = new String[enumConstants.length][2];
        for (int i = 0; i < enumConstants.length; ++i) {
            result[i][0] = enumConstants[i].name();
            result[i][1] = enumConstants[i].name();
        }
        return result;
    }
}

