BEGIN;

CREATE TABLE newszoom_config (
    tenant_id uuid NOT NULL PRIMARY KEY,
    cycle_automatically character(1) NOT NULL DEFAULT 't',
    open_on varchar(255) NOT NULL DEFAULT 'LOGIN',
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now()
);

CREATE TABLE newszoom_section (
    id uuid NOT NULL PRIMARY KEY,
    tenant_id uuid NOT NULL,
    name varchar(100) NOT NULL,
    order_index integer NOT NULL,
    show_only_pinned character(1) NOT NULL DEFAULT 'f',
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now(),
    CONSTRAINT tenant_id_fk FOREIGN KEY (tenant_id) REFERENCES tenant(id) ON DELETE CASCADE

);

CREATE TABLE newszoom_section_channel (
    section_id uuid NOT NULL,
    channel_id VARCHAR(255) NOT NULL,
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now(),
    CONSTRAINT newszoom_section_channel_pk PRIMARY KEY (section_id, channel_id),
    CONSTRAINT section_id_fk FOREIGN KEY (section_id) REFERENCES newszoom_section(id) ON DELETE CASCADE
);

COMMIT;
