BEGIN;

CREATE TABLE app (
    id varchar(32) NOT NULL PRIMARY KEY,
    name varchar(100) NOT NULL,
    is_core_app character(1) NOT NULL,
    default_order integer NOT NULL,
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now()
);

CREATE TABLE additional_app_info (
    app_id varchar(32) NOT NULL PRIMARY KEY,
    url varchar(255) NOT NULL,
    icon_url varchar(255),
    color varchar(16) NOT NULL,
    is_iframe_app character(1) NOT NULL,
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now(),
    CONSTRAINT additional_app_info_app_id_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

CREATE TABLE tenant_app_visibility (
    app_id varchar(32) NOT NULL,
    tenant_id uuid NOT NULL,
    visible_for_role varchar(100) NOT NULL,
    visibility varchar(64) NOT NULL,
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now(),
    CONSTRAINT tenant_app_visibility_pk PRIMARY KEY (app_id, tenant_id, visible_for_role),
    CONSTRAINT tenant_app_visibility_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE);

CREATE TABLE default_app_visibility (
    app_id varchar(32) NOT NULL,
    visible_for_role varchar(100) NOT NULL,
    visibility varchar(64) NOT NULL,
    ctime timestamp NOT NULL DEFAULT now(),
    mtime timestamp NOT NULL DEFAULT now(),
    CONSTRAINT default_app_visibility_pk PRIMARY KEY (app_id, visible_for_role),
    CONSTRAINT default_app_visibility_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

-- insert default core apps and orders
INSERT INTO app(id, name, is_core_app, default_order) VALUES('chat', 'Connect', 't', 1);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('drive', 'Drive', 't', 2);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('tasks', 'Tasks', 't', 3);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('connect', 'Social', 't', 4);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('people', 'People', 't', 5);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('news', 'News', 't', 6);

INSERT INTO default_app_visibility(app_id, visible_for_role, visibility) SELECT id, 'ALL', 'FORCED' FROM app;

COMMIT;
