BEGIN;

CREATE TABLE sh_conversation (
    "id" bigint,
    "type" character varying(255),
    "create_date" timestamp without time zone,
    "title" character varying(1024),
    "last_message_date" timestamp without time zone,
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_conversation_message (
    "id" bigint,
    "conversation_id" bigint,
    "from_person_id" bigint,
    "create_date" timestamp without time zone,
    "message" text,
    "message_type" character varying(32),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("id")
);

CREATE TABLE sh_conversation_participant (
    "conversation_id" bigint,
    "participant_id" bigint,
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "read_date" timestamp without time zone,
    "deleted" character(1),
    "last_mail_sent" timestamp without time zone,
    "deleted_with_conversation" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE sh_conversation_settings (
    "conversation_id" bigint,
    "participant_id" bigint,
    "muted" character(1),
    "create_date" timestamp without time zone,
    "modify_date" timestamp without time zone,
    "hidden" character(1),
    DELETE_ACTION_ID BIGINT,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("conversation_id", "participant_id")
);

INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('conversation','sh_conversation','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('conversation_message','sh_conversation_message','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('conversation_participant','sh_conversation_participant','f');
INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('conversation_settings','sh_conversation_settings','f');

COMMIT;
