BEGIN;

CREATE OR REPLACE FUNCTION check_db_version(min_version INTEGER) RETURNS VOID AS $u$
DECLARE
    db_version INTEGER;
BEGIN
	SELECT setting INTO db_version from pg_settings where name='server_version_num';
	IF db_version < min_version THEN
	   RAISE EXCEPTION 'DB version is obsolete, minimum version requirement not statisfied.';
	END IF;
END 
$u$ language plpgsql;

COMMIT;
