BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00008, '7.5', '00008_#patch_item_visibility_queue.sql', 'FEATURE', '#7229 Sichtbarkeit von Entitäten in der DB speichern', now());

CREATE SEQUENCE item_visibility_queue_seq;

CREATE TABLE item_visibility_queue (
    id BIGINT NOT NULL,
    item_id BIGINT NOT NULL,
    item_type VARCHAR(32) NOT NULL,
    created_at TIMESTAMP DEFAULT clock_timestamp(),
    CONSTRAINT item_visibility_queue_pk PRIMARY KEY (id)
);

CREATE INDEX item_visibility_queue_item_idx ON item_visibility_queue(item_id, item_type);
CREATE INDEX item_visibility_queue_creation_date_idx ON item_visibility_queue(created_at ASC);

CREATE TABLE item_visibility_queue_event (
    item_visibility_queue_id BIGINT NOT NULL,
    event_type VARCHAR(50) NOT NULL,
    CONSTRAINT item_visibility_queue_event_pk PRIMARY KEY (item_visibility_queue_id, event_type),
    CONSTRAINT item_visibility_queue_event_queue_fk FOREIGN KEY (item_visibility_queue_id) REFERENCES item_visibility_queue(id) ON DELETE CASCADE
);

COMMIT;
