BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00001, '7.2', '00001_#patch_add-auditing.sql', 'FEATURE', '#4265 Protokollierung schreibender und löschender Zugriffe in Log-Dateien: RPCs loggen', now());

-- create sequence for auditing log
CREATE SEQUENCE audit_log_seq;

-- create auditing log output table
CREATE TABLE audit_log
(
   id bigint NOT NULL,
   person_id bigint,
   change_date timestamp NOT NULL,
   change_call varchar(255) NOT NULL,
   change_result text NOT NULL,
   CONSTRAINT audit_log_pk PRIMARY KEY (id)
);

-- referenced table for parameter lists within calls being audited
CREATE TABLE audit_log_param
(
   audit_id bigint NOT NULL,
   position int NOT NULL,
   name varchar(255) NOT NULL,
   value text NOT NULL,
   CONSTRAINT audit_log_param_pk PRIMARY KEY (audit_id,position),
   CONSTRAINT audit_log_param_audit_id_fk FOREIGN KEY (audit_id) REFERENCES audit_log (id) ON DELETE CASCADE
);

COMMIT;