BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01316, '6.13', '01316-create-entity-version-table', 'FEATURE', '#4425 Implementierung der Basis für den Freigabe-Workflow von Entitäten', now());


CREATE SEQUENCE entity_version_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NO MAXVALUE
    CACHE 1;

CREATE TABLE entity_version 
(
    id bigint NOT NULL DEFAULT nextval('entity_version_seq'::regclass),
    entity_id bigint NOT NULL,
    parent_version_id bigint,
    person_id bigint NOT NULL,
    major_version integer NOT NULL DEFAULT 0,
    minor_version integer NOT NULL DEFAULT 0,
    draft_version integer NOT NULL DEFAULT 0,
    version_type character varying(255) NOT NULL, -- MAJOR/MINOR/EDITORIAL
    target_type character varying(255),
    version_status  character varying(255) NOT NULL, -- PRIVATE/IN_REVIEW/PUBLIC/DECLINED
    release_date timestamp without time zone,
    expiration_date timestamp without time zone,
    change_message character varying(255),
    comment_for_reviewers character varying(255),
    CONSTRAINT entity_version_pk PRIMARY KEY (id),
    CONSTRAINT entity_version_major_minor_draft_unique UNIQUE (entity_id, major_version, minor_version, draft_version),
    CONSTRAINT entity_version_entity_id_fkey FOREIGN KEY (entity_id)
      REFERENCES entity (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
    CONSTRAINT entity_version_id_fkey FOREIGN KEY (person_id)
      REFERENCES person (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
);

CREATE TABLE entity_version_review 
(
    entity_version_id bigint NOT NULL,
    reviewer_id bigint NOT NULL,
    inviter_id bigint NOT NULL,
    review_status character varying(255) NOT NULL,
    review_order bigint NOT NULL,
    CONSTRAINT entity_version_review_pk PRIMARY KEY (entity_version_id, reviewer_id), 
    CONSTRAINT entity_version_id_fkey FOREIGN KEY (entity_version_id)
        REFERENCES entity_version (id) MATCH SIMPLE
        ON UPDATE NO ACTION ON DELETE CASCADE,
    CONSTRAINT entity_version_review_person_fkey FOREIGN KEY (reviewer_id)
        REFERENCES person (id) MATCH SIMPLE
        ON UPDATE NO ACTION ON DELETE CASCADE, 
    CONSTRAINT entity_version_review_inviter_fkey FOREIGN KEY (inviter_id)
        REFERENCES person (id) MATCH SIMPLE
        ON UPDATE NO ACTION ON DELETE CASCADE, 
    CONSTRAINT entity_version_release_order_unique UNIQUE (entity_version_id, review_order)
);

COMMIT;
