BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01296, '6.11', 'remove navigation separator', 'FEATURE', 'removing color, text and background image of the navigation separator', now());

ALTER TABLE entity_design DROP COLUMN navigation_separator;
ALTER TABLE entity_design DROP COLUMN navigation_separator_background_color;
ALTER TABLE entity_design DROP COLUMN navigation_separator_text_color;

-- Removing navigation separator from predefined designs by deleting the 4th and 5th color of each design.
UPDATE base_property
SET default_value =
regexp_replace(
    (SELECT default_value
        FROM base_property
        WHERE property_name = 'Settings/Networks/Designs/predefined network designs'
        AND container_name = 'systemSettings'),
    '([^,]*,[^,]*,[^,]*,)([^|,]*,[^|,]*,)([^|]*[|])',
    E'\\1\\3',
    'ig')
WHERE property_name = 'Settings/Networks/Designs/predefined network designs'
AND container_name = 'systemSettings';

COMMIT;
