BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date") VALUES (01269, '6.8', 'add_recent_to_like', 'FEATURE', '#3418 Anzeige der Nutzer, die einen Microblog-Beitrag geliked haben', now());

-- replace now() with clock_timestamp() for testing
ALTER TABLE "like" ALTER created_at SET DEFAULT clock_timestamp();
ALTER TABLE "like" ALTER modified_at SET DEFAULT clock_timestamp();

-- add and fill new recent column
ALTER TABLE "like" ADD recent BOOLEAN NOT NULL DEFAULT false;

CREATE INDEX like_created_at_idx ON "like"(item_id, item_type, created_at);

UPDATE "like" l1
SET recent = true
WHERE liker_id in (
      SELECT liker_id
          FROM "like" l2
          WHERE l1.item_id = l2.item_id AND l1.item_type = l2.item_type
          ORDER BY created_at DESC
          LIMIT 3
);

CREATE INDEX like_recent_idx ON "like"(item_id, item_type, recent);

COMMIT;
