BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01239, '6.5', 'refactor-subscription-like', 'FEATURE', 'Refactor subscription/like tables', now());

DROP TABLE IF EXISTS "like" CASCADE;
CREATE TABLE "like" (
    liker_id BIGINT REFERENCES person(person_id) ON DELETE CASCADE NOT NULL,
    item_id BIGINT NOT NULL,
    item_type VARCHAR NOT NULL,
    created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT NOW(),
    modified_at TIMESTAMP WITHOUT TIME ZONE DEFAULT NOW(),
    CONSTRAINT like_pkey PRIMARY KEY (item_id, item_type, liker_id)
);
CREATE INDEX like_liker_id_idx ON "like" (liker_id);

DROP TABLE IF EXISTS like_subscribe CASCADE;
CREATE TABLE like_subscribe (
    subscriber_id BIGINT REFERENCES person(person_id) ON DELETE CASCADE NOT NULL,
    item_id BIGINT NOT NULL,
    item_type VARCHAR NOT NULL,
    created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT NOW(),
    modified_at TIMESTAMP WITHOUT TIME ZONE DEFAULT NOW(),
    CONSTRAINT like_subscribe_pkey PRIMARY KEY (item_id, item_type, subscriber_id)
);

COMMIT;
